/***************************************************************************
                          waterfall.h  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WATERFALL_H
#define WATERFALL_H

#include <qwidget.h>
#include <qcolor.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtimer.h>
#include "kpsktip.h"

#include "auxwindow.h"

/**
  *@author Luc Langehegermann
  */


class waterfall : public QWidget  {
  Q_OBJECT
public: 
	waterfall(QWidget *parent=0);
	~waterfall();
  int getIMD (int chn);
  void reInit();
  int lastpos[4]; // last sample position
  int stranslate[SAMPLES]; // fft samples to x coordinates
  KpskTip* ktip;  // tooltip class
  void incrementFreq(); // increments freq by FREQ_INCREMENT
  void decrementFreq(); // decrements freq by FREQ_INCREMENT


private:
	QPixmap getLineal (double offset, bool lsb = false);
	int activechannel;
  int freq;
	QPixmap buffer; //screen buffer
  QPixmap lineal;
  QPixmap marker;
	QPixmap activemarker;
	
	QTimer* timer; // timer for waterfall processing



	auxWindow* aux[3];
  int IMD[4];
	int IMDcount[4];
  int maxfreq;  // maximum displayed frequency
  int minfreq;  // minimum displayed frequency
  int xmax;     // maximum x plot coordinate
  int ymax;     // maximum y plot coordinate
  int xpos;     // x coordinate position
  int large_step_width;  // plot step of lareg freq ticks
  int marker_step_width; // plot step of freq marker
  int marker_freq_step;  // freq step of freq marker
  float to;  //max visible in sample space
  float from;  // min visible in sample space
  unsigned int xtranslate[SAMPLES]; // x coordinate matrix of fft samples

	QColor watercolor[100]; //waterfall color or grayscale matrix
protected: // Protected methods
  void mousePressEvent (QMouseEvent* event);
	void mouseMoveEvent (QMouseEvent* event);
  void resizeEvent (QResizeEvent* e);
  void paintEvent (QPaintEvent*);
private slots: // Private slots
  void slotProcessFFTData();
private: // Private methods
  void h2oColors();  // makes color valus
  void mkGray(); // makes grayscale values
  void translate(); // converts x coordinates to samples & samples to x
public slots: // Public slots
  void slotNewBand (int item);
  void slotClrCh1Rx(); // slot to clear ch 1 text
  void slotClrCh2Rx(); // slot to clear ch 2 text
  void slotClrCh3Rx(); // slot to clear ch 3 text
};

#endif

