//
// C++ Interface: kpgcreatetablewidget5
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATETABLEWIDGET5_H
#define KPGCREATETABLEWIDGET5_H

#include "kpgcreatetablewidget5base.h"

/**
Widget for create table wizard - define table grants

@author Lumir Vanek
*/

class KPGCreateTableWidget5 : public KPGCreateTableWidget5Base
{
Q_OBJECT
public:
    KPGCreateTableWidget5(QWidget *parent, const char *name, bool);
    ~KPGCreateTableWidget5();
    
	void setTableName(const QString &strTableName) { m_strTableName = strTableName; }
	void setNamespace(const QString &strNamespace) { m_strNamespace = strNamespace; }
	const QString getSQL() const;
		

protected:
	void enableAddGrantButton();
	
protected:
	QString m_strTableName; // name of the created table
	QString m_strNamespace; // name of the namespace
		
    QString strGR; // contain GRANT or REVOKE
    QString strTF; // contain TO or FROM
    
    bool m_bGrantOrRevoke;
    
protected slots:

	virtual void slotCheckBoxAllToggled(bool);
	virtual void slotCheckBoxSelectToggled(bool);
	virtual void slotCheckBoxInsertToggled(bool);
	virtual void slotCheckBoxUpdateToggled(bool);
	virtual void slotCheckBoxDeleteToggled(bool);
	virtual void slotCheckBoxRuleToggled(bool);
    virtual void slotCheckBoxReferencesToggled(bool);
    virtual void slotCheckBoxTriggerToggled(bool);
    virtual void slotGrantOptionsToggled(bool);
    
	virtual void slotCheckBoxPublicToggled(bool);
	virtual void slotListBoxUsersSelectionChanged();
		
	virtual void slotGrantsSelectionChanged(QListViewItem *);
    virtual void slotGrantsCurrentChanged(QListViewItem *);
		
	virtual void slotGrantAdd();
    virtual void slotGrantDelete();
						
signals:
	void sigEnableNextButton(bool);	
};

#endif
