//
// C++ Implementation: kpgcreatedatabasewizard
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcreatedatabasewizard.h"

// include files for Qt
#include <qlayout.h>

// include files for KDE
#include <klineedit.h>
#include <kcombobox.h>
#include <ktextedit.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

// application specific includes
#include "../DbObjects/kpgserver.h"
#include "../DbObjects/kpgusersfolder.h"
#include "../DbObjects/kpggroupsfolder.h"
#include "../DbObjects/kpgtablespacesfolder.h"
#include "kpgcreatedatabasewidget1.h"
#include "kpgcreatedatabasewidget2.h"


KPGCreateDatabaseWizard::KPGCreateDatabaseWizard(QWidget *parent, const char *name, KPGServer *pServer)
 : KPG4StepsWizard(parent, name)
{
	KPGCreateDatabaseWidget1 *pCreateDatabaseWidget1 = new KPGCreateDatabaseWidget1(WizardPage1, "KPGCreateDatabaseWidget1", pServer);
	m_pPageWidget1 = pCreateDatabaseWidget1;
	WizardPage1Layout->addWidget(m_pPageWidget1, 0, 0);
	connect(pCreateDatabaseWidget1, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton1(bool)));
  
  KPGCreateDatabaseWidget2 *pCreateDatabaseWidget2 = new KPGCreateDatabaseWidget2(WizardPage2, "KPGCreateDatabaseWidget2");
  m_pPageWidget2 = pCreateDatabaseWidget2;
  WizardPage2Layout->addWidget(m_pPageWidget2, 0, 0);
  //connect(pCreateDatabaseWidget2, SIGNAL(sigEnableNextButton(bool)), this, SLOT(slotEnableNextButton2(bool)));
	
  
  if(pServer->versionMajor() >= 8)
  {
    pServer->getTablespacesFolder()->fillComboBoxWithChildItems(pCreateDatabaseWidget1->m_pComboBoxTablespace);
    pCreateDatabaseWidget1->m_pLineEditLocation->setEnabled(false);
  }
  else
    pCreateDatabaseWidget1->m_pComboBoxTablespace->setEnabled(false);
  
  pServer->getGroupsFolder()->fillListBoxWithChildItems(pCreateDatabaseWidget2->m_pListBoxUsersGroups);
  pServer->getUsersFolder()->fillListBoxWithChildItems(pCreateDatabaseWidget2->m_pListBoxUsersGroups);
    
	languageChange();
  
  setNextEnabled(WizardPage2, true);
}


KPGCreateDatabaseWizard::~KPGCreateDatabaseWizard()
{
}

void KPGCreateDatabaseWizard::languageChange()
{
    KPG4StepsWizard::languageChange();
		
		setCaption( i18n( "Create new database" ) );
		
    setTitle( WizardPage1, i18n( "Step 1 - Database name and another optional properties" ) );
    setTitle( WizardPage2, i18n( "Step 2 - Define user rights" ) );
    setTitle( WizardPage3, i18n( "Step 3 - Review SQL statement" ) );
    setTitle( WizardPage4, i18n( "Step 4 - Check operation result" ) );
}

// When this function called, initialize appropriate Wizard page
void KPGCreateDatabaseWizard::showPage(QWidget *pPage)
{
  if(pPage == WizardPage2) // Step 2 - Define user rights
  {
    KPGCreateDatabaseWidget1 *pCreateDatabaseWidget1 = static_cast <KPGCreateDatabaseWidget1 *> (m_pPageWidget1);
    KPGCreateDatabaseWidget2 *pCreateDatabaseWidget2 = static_cast <KPGCreateDatabaseWidget2 *> (m_pPageWidget2);
        
    // Set database name
    pCreateDatabaseWidget2->setDatabaseName(pCreateDatabaseWidget1->m_pLineEditDatabaseName->text());
  }
  
	if(pPage == WizardPage3) // Step 3 - Review SQL statement
	{
		// prepare SQL statement
		QString strSQL;
		strSQL.append((static_cast <KPGCreateDatabaseWidget1 *> (m_pPageWidget1))->getSQL());
		strSQL.append(";\n\n");
    strSQL.append((static_cast <KPGCreateDatabaseWidget2 *> (m_pPageWidget2))->getSQL());
		
		m_pTextEditSQL->setText(strSQL);
	}
	
	if(pPage == WizardPage4) // Step 4 - Check operation result
	{
		runQuery(false);
	}
	
	// call parent
	KPG4StepsWizard::showPage(pPage);
}

#include "kpgcreatedatabasewizard.moc"
