//
// C++ Interface: kpgqueryresultwindow
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGQUERYRESULTWINDOW_H
#define KPGQUERYRESULTWINDOW_H

#include "kpgqueryresultwindowbase.h"

#include <qregexp.h>

#include <kparts/factory.h> // KPart Factory
#include <kate/view.h>      // Katepart view

#include "../kpgconnectioninthread.h"
#include "../Wizards/kpgtablecolumnwizinfo.h"

class QListViewItem;
class KFind;
//class KCompletionBox;
class KXMLGUIFactory;

class KPGDatabase;
class KPoGreView;
class KPGQueryResultChildView;


/**
  * SQL Query / result window. 
  * Allow enter SQL query, run it and display the result.
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGQueryResultWindow : public KPGQueryResultWindowBase, virtual public KXMLGUIClient
{
	Q_OBJECT
public: 
	KPGQueryResultWindow(KPGQueryResultChildView *, KPoGreView *, KParts::Factory* , KXMLGUIFactory *, const QString &, const QString &);
	~KPGQueryResultWindow();
    
    // Enumerates code completion modes
     enum ECompletionMode { modeNone = 0, modeMainObjects, modeSchemaChilds, modeTableColumns };
    
    // Open document from given URL
    void loadURL(const KURL &);
    
    // Get document encoding
    const QString encoding() const;
    
    // Set document encoding
    void setEncoding(const QString& );
    
    // Get document URL
	const KURL url() const;
	
    // Get editor text
    const QString editorText() const;
    
    // Add yourself and Kate view to GUI factory
    void addToGuiFactory();
    
    // Remove yourself and Kate view from GUI factory
    void removeFromGuiFactory();
    
    // Display popup menu
	void popupContextMenu(const QString &, const QPoint &);
	
    // Set state of action Run query
    void setEnableRunQuery(bool bEnable);
      	  	
  	// Returns QTable with result
  	QTable *tableResult() const { return m_pTableResult; }

	// Is SQL query changed after last open/save ?
	bool isModified() const;
	
	// Set flag indicating changed query text
	void setQueryTextChanged(bool);
	
	// Signalize, if result contain at least one row
	bool resultEmpty() const;
  
  	// Is all rows fetched from resultset do m_pTableResult ?
  	bool fetchedAllRows() const { return m_nTotalRows == m_nFetchedRows;  }
  
  	// Lookup KPGDatabase for selected server and database in combo boxes 
  	KPGDatabase * lookupDatabase(QListViewItem *);
  		
	// Returns TRUE if the connection thread is running; otherwise returns FALSE.
	bool running() const { return  m_connectionInThread.running(); }
	
	// Fetch next X rows from large result
	void fetchNext();
	
	// Fetch all rows from large result  
	void fetchAll();
	
	// Filters events
	bool eventFilter(QObject *, QEvent *);
	
	//-------------------------------------------------------------------------
    //
    // Code completion implementation
    //
    //-------------------------------------------------------------------------
    
	// Set list of main DB objects for code completion to SQL editor 
	void setListOfObjectsForCodeCompletion(const KPGOidNameList &);
	
	// Clear list of objects for code completion to SQL editor 
	void clearListOfObjectsForCodeCompletion();
	
	// Clear list of schema childs for code completion
	void clearListOfSchemaChildsForCodeCompletion();
	
	// Set list of schema childs for code completion to SQL editor 
	void setListOfSchemaChildsForCodeCompletion(const KPGOidNameList &);
	
	// Set list of table columns/type attributes for code completition to SQL editor 
	void setListOfColumnsForCodeCompletion(const KPGListTableColumns &);
	
	// Clear list of table columns for code completition
	void clearListOfColumnsForCodeCompletion();
				
	//-------------------------------------------------------------------------
    //
    // Find in result implementation
    //
    //-------------------------------------------------------------------------
    			
	// Find first occurence of text in result table
	void findInResultFirst(QStringList &);
		
	// Find next occurence of text in result table
	void findInResultNext();
		
	//-------------------------------------------------------------------------
	//
    // Code snipets support
	//
    //-------------------------------------------------------------------------
	
	// Insert code snippet
	void insertSnippet(const QString &);
	
protected:
   
    // Create Kate part view
	Kate::View* createKatePart(KParts::Factory*);
	
	// Set editor text
    void setEditorText(const QString &);
    
    // Receive event from KPGConnectionInThread
    virtual void customEvent(QCustomEvent *);

    // Display SQL result
    void displayResult();
    
    // Display query execution time
    void displayExecutionTime(int);
  
  	void updateTabToolTip();
  
	// Run SQL query
	void runQuery(KPGDatabase *);
	
	// Terminate thread that run SQL query
	void stopQuery();
    
    virtual void virtual_hook(  int id, void* data );

	//-------------------------------------------------------------------------
    //
    // Code completion implementation
    //
    //-------------------------------------------------------------------------

	// Return the string to complete (the letters behind the cursor)
	QString word();
	
	// Return the string to complete (the letters behind the cursor), like xxx.
	QString wordBeforeDot();
	
	// Get uncompleted word, set it to completition and set completed items to box, eventually show it
    void updateCtrlSpaceCompletion();
    
    // Set table columns into completion if table name is left before period: table.
    void updatePeriodCompletion();
    
    // Set completed items to box, eventually show it
	void updateCompletion(const QString &, const QValueList<KTextEditor::CompletionEntry> &);
	
	// Set completed items to box, eventually show it
	void updateCompletion(const QValueList<KTextEditor::CompletionEntry> &);

public slots:

	void slotDatabaseChanged(const QString&);
  
protected slots:
    
	//--- Query/result actions
	void slotRunQuery();
    void slotStopQuery();
    void slotFetchNext();
    void slotFetchAll();
    void slotFindInResult();
    void slotFindNextInResult();

	//--- Common clibpoard actions
    void slotCopyCell();
    void slotCopyRow();
    void slotCopyTableCsv();
    void slotCopyTableXml();
    
	// Display popup menu for result QTable
	void slotContextMenuRequested(int, int, const QPoint &);
	
	// Fired, when server changed in combobox
	void slotServerChanged(const QString &);
    
	// Called, when user change text in SQL input area. Mark document as modified.
   	void slotTextEditQueryTextChanged();
   	
   	// SQL file name changed
   	void slotFileNameChanged();
   	
   	// Called, when Kate editor change status message
   	void slotTextEditStatusMsg(const QString &);

	virtual void slotExplainToggled(bool);
	
	virtual void slotButtonOptionsToggleg(bool);
	
	//-------------------------------------------------------------------------
    //
    // Code completion related slots
    //
    //-------------------------------------------------------------------------
    
	// Called, when m_pTextEditQuery needed schema childs list, for code completion 
	void slotRequestSchemaChildsListsForCodeCompletion(pqxx::oid);
	
	// Called, when m_pTextEditQuery needed table columns list, for code completion 
	void slotRequestTableColumnsListsForCodeCompletion(const KPGOidNameAliases *);
	
	// Called, when m_pTextEditQuery needed function columns list, for code completion 
	void slotRequestFunctionReturnTypeAttributesListsForCodeCompletion(const KPGOidNameAliases *);
	
	// Fired from m_pUpdateCodeCompletionListTimer
    void slotUpdateCodeCompletionList();
	
	// Fired when the completion list disappears and a completion has been inserted into text.
	void slotCompletionDone();
	
	// Fired when the completion list disappears and no completion has been done
	void slotCompletionAborted();
	
	// Find next occurence of text
    void slotFindInResultNext();
    
    // Highligth found text
    void slotHighlight( const QString &, int, int);
	
	// Process notice from connection in thread
    void slotProcessNotice(const QString &);
	
private:
	int max(int a, int b) { return a > b ? a : b; }
	int min(int a, int b) { return a < b ? a : b; }
		
signals:

	// Emited, when info about databases list is needed
	void sigRequestDatabasesList(KPGQueryResultWindow *, const QString&);
	
	// Emited, when database is selected and list of object for code completition is needed
	void sigRequestListOfDatabaseObjectsForCodeCompletion(KPGQueryResultWindow *, const QString&);
	
	// Emited, when m_listOfCodeCompletionSchemaChilds need update
	void sigRequestSchemaChildsListsForCodeCompletion(KPGQueryResultWindow *, pqxx::oid);
	
	// Emited, when list of code completion table columns need update
	void sigRequestTableColumnsListsForCodeCompletion(KPGQueryResultWindow *, const KPGOidNameAliases *);
	
	// Emited, when list of code completion table columns need update
	void sigRequestFunctionReturnTypeAttributesListsForCodeCompletion(KPGQueryResultWindow *, const KPGOidNameAliases *);
				
	// Emited for request to change terminal icon in QTabWidget 
	void sigSetTerminalIcon(KPGQueryResultWindow *, int);
	
	// Emited when need update tooltip text
	void sigUpdateTabTooltip(const QString &);
	
	void sigFileNameChanged(const QString &);
		  
protected:

	// For replacing in data tables and result tables
	QStringList m_listOfQueryReplacementHistory;
	
	// For searching in data tables and result tables
	QStringList m_listOfResultQuerySearchHistory;

	// Main app view
	KPoGreView *m_pPoGreView;

	// Query/result actions
	KAction* m_pActRunQuery;
    KAction* m_pActStopQuery;
    KAction* m_pActFetchNext;
    KAction* m_pActFetchAll;
    KAction* m_pActFindInResult;
    KAction* m_pActFindNextInResult;
	    
	// Common clipboard actions
    KAction* m_pActCopyCell;
	KAction* m_pActCopyRow;
	KAction* m_pActCopyTableCsv;
	KAction* m_pActCopyTableXml;
	
	// Kate part editor
    Kate::View* m_pKateView;

	// True, if Kate View is in GUI factory
    bool m_bIsAddedToGuiFactory;

    // GUI factory
    KXMLGUIFactory *m_pXmlGuiFactory;
    
    // Codec for encode/decode strings from/to database
    QTextCodec *m_pTextCodec;
	
	// Number of higlighting mode to set
	uint m_iHighlightMode;
	
	// Thread that run queries on background
	KPGConnectionInThread m_connectionInThread;
	
	// Resultset to display
	pqxx::result m_pqxxResult;
	
	unsigned int m_nTotalRows; // Number of rows in result
	unsigned int m_nFetchedRows; // Number of fetched rows from result
	unsigned int m_nTotalCols; // Number of columns in result
	
	//-------------------------------------------------------------------------
    //
    // Code completion variables
    //
    //-------------------------------------------------------------------------

	// Regexp for code completion support
	QRegExp m_RegExp;
	
	// List of main database objects for code completition, from PUBLIC schema
	KPGOidNameAliasesList m_listOfCodeCompletionObjects;
	
	// List of schema childs (tables, views, functions, sequences) for code completition
	KPGOidNameList m_listOfCodeCompletionSchemaChilds;
	
	// List of table/function columns for code completition
	KPGListTableColumns m_listOfCodeCompletionColumns;
	
	// List of code completion entries
	//QValueList<KTextEditor::CompletionEntry> m_completionList;
	
	// Flag, indicating, if m_listOfCodeCompletionObjects need to be updated.
	bool m_bCodeCompletionListUpdated;
	
	// Timer, that ensure periodically update m_listOfCodeCompletionObjects
	QTimer *m_pUpdateCodeCompletionListTimer;
	
	// Current completition mode
	ECompletionMode m_eCompletionMode;
	
private:
	// A generic implementation of the "find" function
	KFind *m_pFind;
	
	int m_iRowToSearch;
	int m_iColToSearch;
};

#endif
