//
// C++ Implementation: kpgtablespaceproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgtablespaceproppage.h"

// include files for Qt
#include <qiconset.h>
#include <qtable.h> 

// include files for KDE
#include <ktabwidget.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kdebug.h>
#include <klocale.h>

#include "../DbObjects/kpgtablespace.h"


KPGTablespacePropPage::KPGTablespacePropPage(QWidget *parent, KPGTablespace * pTablespace)
 : KPGTablespacePropPageBase(parent, "KPGTablespacePropPage")
{
	m_pTablespace = pTablespace;
	m_pTabWidget->setTabIconSet(tabACL, QIconSet(QPixmap(UserIcon("group"))));
	
	displayProperties();
}


KPGTablespacePropPage::~KPGTablespacePropPage()
{
}

void KPGTablespacePropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
		
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pTablespace->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pTablespace->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Name of the tablespace"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
  	m_pTableProperties->setText(iRow, 1, m_pTablespace->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the tablespace"));
	
	//--- Location
	m_pTableProperties->setText(iRow, 0, i18n("Location"));
  	m_pTableProperties->setText(iRow, 1, m_pTablespace->location());
	m_pTableProperties->setText(iRow++, 2, i18n("Location of the tablespace"));
	
	//--- Pretty size
	m_pTableProperties->setText(iRow, 0, i18n("Rounded size"));
	if(m_pTablespace->version81_OrNewer())
	 	m_pTableProperties->setText(iRow, 1, m_pTablespace->prettySize());
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the tablespace"));
	
	//--- Exact size
	m_pTableProperties->setText(iRow, 0, i18n("Exact size"));
	if(m_pTablespace->version81_OrNewer())
	 	m_pTableProperties->setText(iRow, 1, QString("%L1 B").arg(m_pTablespace->size()));
	else
		m_pTableProperties->setText(iRow, 1, "N/A");
	m_pTableProperties->setText(iRow++, 2, i18n("Disk space used by the tablespace"));
	
	//--- ACL
	setACL(m_pTablespace->acl());
  
	for(int nCol = 0; nCol < 3; nCol++)
	{
		m_pTableProperties->adjustColumn(nCol);
	}
}

void KPGTablespacePropPage::setACL(const QString &strACL)
{
	m_pListViewACL->clear();
	m_listOfAclItems.clear();
	m_pLineEditACL->setText(strACL);
	
	QString strAclItem; // string for one ACL item, e.g. miriam=arwdRxt/miriam
	for(unsigned int i = 0; i < strACL.length(); i++)
	{
		if(strACL[i] == '{')
		continue;
		
		if((strACL[i] == ',') || (strACL[i] == ','))
		{
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
		strAclItem.truncate(0); // clear ACL string
		}
		else
		{
		strAclItem.append(strACL[i]);
		}
	}
	
	if(!strAclItem.isEmpty())
		m_listOfAclItems.append(KPGAclItem(strAclItem)); // create new ACL item
	
	// Traverse list of ACL items
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		QListViewItem * pItem = new QListViewItem( m_pListViewACL, 0 );
		(*it).setListViewItem(pItem);
		
		pItem->setText( 0, (*it).grantee() );
		pItem->setText( 1, (*it).grantor() );
		
		pItem->setPixmap(2, UserIcon((*it).canCreate() ? "box_checked" : "box_clear"));
		
		if((*it).canPassGrantToOther())
		pItem->setPixmap(3, UserIcon((*it).canGrantCreate() ? "box_checked" : "box_clear"));
	} 
}

void KPGTablespacePropPage::slotAclListViewClicked(QListViewItem *pItem, const QPoint &, int iColumn)
{
	// Find KPGAclItem using pItem value
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		if(pItem == (*it).getListViewItem())
		{
		// found ...
		
		switch(iColumn)
		{
			case 0:
			case 1: // do nothing on first 2 columns
				break;
			
			case 2:
				pItem->setPixmap(2, UserIcon((*it).toggleCreate() ? "box_checked" : "box_clear"));
				break;
		
			case 3:
				if((*it).canPassGrantToOther())
				pItem->setPixmap(3, UserIcon((*it).toggleGrantCreate() ? "box_checked" : "box_clear"));
				
				break;
				
			default:
					kdError() << k_funcinfo << " Unexpected column !" << endl;
					break;      
		}
		
		m_pPushButtonUpdateACL->setEnabled(true);
		return;
		}
	}
}

void KPGTablespacePropPage::slotUpdateACL()
{
	QString strSQL;
	
	// Traverse all items and get their SQL's
	KPGAclItemList::iterator it;
	for ( it = m_listOfAclItems.begin(); it != m_listOfAclItems.end(); ++it )
	{   
		strSQL.append((*it).getSQL("TABLESPACE " + m_pTablespace->text(0)));
	}
	
	if(!strSQL.isEmpty())
		emit sigRunWizard(strSQL);
}

// Consumes request for context menu for property table
void KPGTablespacePropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgtablespaceproppage.moc"
