//
// C++ Interface: kpgsequenceproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGSEQUENCEPROPPAGE_H
#define KPGSEQUENCEPROPPAGE_H

#include "kpgsequenceproppagebase.h"

// include files for libpgxx 
#include <pqxx/util> 

// application specific includes
#include "kpgabstractpropertypage.h"
#include "../kpgaclitem.h"

class KPGSequence;

/**
  * Sequence properties
  *
  * @author Lumir Vanek
  */
class KPGSequencePropPage : public KPGSequencePropPageBase, public KPGAbstractPropertyPage
{
	Q_OBJECT
public:
    KPGSequencePropPage(QWidget *parent, KPGSequence *);
    ~KPGSequencePropPage();
        
    // Display properties of underlying database object    
    virtual void displayProperties();
  	void displayIoStatistics();    
        
    // Return Result table for clipboard actions and export. 
	virtual QTable* tableResult() { return m_pTableProperties; }
	    
    void setACL(const QString &);
    
protected:

    KPGSequence *m_pSequence;
    KPGAclItemList m_listOfAclItems;
    
protected slots:
    
	virtual void slotTablePropDblClicked(int, int, int, const QPoint &);
		            
	// Consumes request for context menu for property table
	virtual void slotTablePropContextMenuRequested(int, int, const QPoint &);    
		
	virtual void slotRefreshStatistics();
    virtual void slotAclListViewClicked(QListViewItem *, const QPoint &, int);
    virtual void slotUpdateACL();
    
signals:

	void sigSearchObject(pqxx::oid);
	
    void sigRunWizard(const QString &);
                
    // Emit request for context menu for property table
	void sigTablePropContextMenuRequested(int, int, const QPoint &);
};

#endif
