//
// C++ Implementation: kpgoperatorproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgoperatorproppage.h"

#include <qtable.h>  

// include files for KDE
#include <kdebug.h>
#include <klocale.h>
#include <ktextedit.h>

#include "../kpgutil.h"
#include "../kpglinklabel.h"
#include "../DbObjects/kpgoperator.h"

KPGOperatorPropPage::KPGOperatorPropPage(QWidget *parent, KPGOperator * pOperator)
 : KPGOperatorPropPageBase(parent, "KPGOperatorPropPage")
{
	m_pOperator = pOperator;
	displayProperties();
}


KPGOperatorPropPage::~KPGOperatorPropPage()
{
}

void KPGOperatorPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;
  	
	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
  	m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pOperator->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
	
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
  	m_pTableProperties->setText(iRow, 1, m_pOperator->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Operator name"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
  	m_pTableProperties->setText(iRow, 1, m_pOperator->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the operator"));
	
	//--- Kind
	m_pTableProperties->setText(iRow, 0, i18n("Kind"));
    m_pTableProperties->setText(iRow, 1, m_pOperator->kind());
	m_pTableProperties->setText(iRow++, 2, i18n("b = infix (\"both\"), l = prefix (\"left\"), r = postfix (\"right\") "));
	
	//--- Can Hash
	m_pTableProperties->setText(iRow, 0, i18n("Can Hash"));
    m_pTableProperties->setPixmap(iRow, 1, m_pOperator->canHash() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("This operator supports hash joins"));
	
	//--- Left Type name
	m_pTableProperties->setText(iRow, 0, i18n("Left type"));
    KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Left type" );
	pLabel->setValues(m_pOperator->oidLeftType(), m_pOperator->leftType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Type of the left operand"));
	
	//--- Right Type name
	m_pTableProperties->setText(iRow, 0, i18n("Right type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Right type" );
	pLabel->setValues(m_pOperator->oidRightType(), m_pOperator->rightType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Type of the right operand"));
	
	//--- Return Type name
	m_pTableProperties->setText(iRow, 0, i18n("Result type"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Result type" );
	pLabel->setValues(m_pOperator->oidResultType(), m_pOperator->resultType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Type of the result"));
	
	//--- Comutator
	m_pTableProperties->setText(iRow, 0, i18n("Comutator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Comutator" );
	pLabel->setValues(m_pOperator->oidComutatorOpr(), m_pOperator->comutatorOprName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Commutator of this operator, if any"));
	
	//--- Negator
	m_pTableProperties->setText(iRow, 0, i18n("Negator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Negator" );
	pLabel->setValues(m_pOperator->oidNegatorOpr(), m_pOperator->negatorOprName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Negator of this operator, if any"));
		
	//--- Left-hand Ooperator
	m_pTableProperties->setText(iRow, 0, i18n("Left-hand operator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Left-hand operator" );
	pLabel->setValues(m_pOperator->oidLeftSortOpr(), m_pOperator->leftSortOprName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("If this operator supports merge joins, the operator that sorts the type of the left-hand operand (L<L) "));
	
	//--- Right-hand Ooperator
	m_pTableProperties->setText(iRow, 0, i18n("Right-hand operator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Right-hand operator" );
	pLabel->setValues(m_pOperator->oidRightSortOpr(), m_pOperator->rightSortOprName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("If this operator supports merge joins, the operator that sorts the type of the right-hand operand (R<R) "));
	
	//--- Less-than operator
	m_pTableProperties->setText(iRow, 0, i18n("Less-than operator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Less-than operator" );
	pLabel->setValues(m_pOperator->oidLessThanOpr(), m_pOperator->lessThanOprName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);	
	m_pTableProperties->setText(iRow++, 2, i18n("If this operator supports merge joins, the less-than operator that compares the left and right operand types (L<R) "));
	
	//--- Greater-than Operator
	m_pTableProperties->setText(iRow, 0, i18n("Greater-than operator"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Greater-than operator" );
	pLabel->setValues(m_pOperator->oidGreatherThanOpr(), m_pOperator->greatherThanOprName());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("If this operator supports merge joins, the greater-than operator that compares the left and right operand types (L>R)"));
	
	//--- Function
	m_pTableProperties->setText(iRow, 0, i18n("Function"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Function" );
	pLabel->setValues(m_pOperator->oidOperatorFunc(), m_pOperator->operatorFunc());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Function that implements this operator"));
		
	//--- Restriction func.
	m_pTableProperties->setText(iRow, 0, i18n("Restriction func."));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Restriction func." );
	pLabel->setValues(m_pOperator->oidRestrictionFunc(), m_pOperator->restrictionFunc());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Restriction selectivity estimation function for this operator"));
	
	//--- Join func.
	m_pTableProperties->setText(iRow, 0, i18n("Join function"));
    pLabel = new KPGLinkLabel( m_pTableProperties, "Join func." );
	pLabel->setValues(m_pOperator->oidJoinFunc(), m_pOperator->joinFunc());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("Join selectivity estimation function for this operator"));
	
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
    m_pTableProperties->setText(iRow, 1, m_pOperator->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Operator owner"));
	
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

void KPGOperatorPropPage::slotTablePropDblClicked(int iRow, int iCol, int /*iButton*/, const QPoint & /*ptMousePos*/)
{
	QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
	if(w == 0)
		return;
					
	KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
	pqxx::oid _oid = pLabel->oid();
			
	if(_oid != 0)
		emit sigSearchObject(_oid);
}

// Consumes request for context menu for property table
void KPGOperatorPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}

#include "kpgoperatorproppage.moc"
