//
// C++ Implementation: kpgdomainproppage
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdomainproppage.h"

#include <qtable.h>  

#include <kdebug.h>
#include <klocale.h>

#include "../kpgutil.h"
#include "../kpglinklabel.h"
#include "../DbObjects/kpgdomain.h"

KPGDomainPropPage::KPGDomainPropPage(QWidget *parent, KPGDomain *pDomain)
 : KPGDomainPropPageBase(parent, "KPGDomainPropPage")
{
	m_pDomain = pDomain;
	displayProperties();
}


KPGDomainPropPage::~KPGDomainPropPage()
{
}

void KPGDomainPropPage::displayProperties()
{
	QHeader* pHeader = m_pTableProperties->horizontalHeader();

  	pHeader->setLabel(0, i18n("Name"));
	pHeader->setLabel(1, i18n("Value"));
	pHeader->setLabel(2, i18n("Description"));
	
	int iRow = 0;

	//--- OID
	m_pTableProperties->setText(iRow, 0, i18n("OID"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pDomain->oid()));
	m_pTableProperties->setText(iRow++, 2, i18n("PostgreSQL row identifier"));
		
	//--- Name
	m_pTableProperties->setText(iRow, 0, i18n("Name"));
    m_pTableProperties->setText(iRow, 1, m_pDomain->text(0));
	m_pTableProperties->setText(iRow++, 2, i18n("Domain name"));
	
	//--- Description
	m_pTableProperties->setText(iRow, 0, i18n("Description"));
    m_pTableProperties->setText(iRow, 1, m_pDomain->description());
	m_pTableProperties->setText(iRow++, 2, i18n("Description of the domain"));
	
	//--- Base type
	m_pTableProperties->setText(iRow, 0, i18n("Base type"));
    KPGLinkLabel *pLabel = new KPGLinkLabel( m_pTableProperties, "Language function" );
	pLabel->setValues(m_pDomain->oidBaseType(), m_pDomain->baseType());
	m_pTableProperties->setCellWidget(iRow, 1, pLabel);
	m_pTableProperties->setText(iRow++, 2, i18n("The type that this domain is based on"));
	
	//--- Type length
	m_pTableProperties->setText(iRow, 0, i18n("Type length"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pDomain->typLen()));
	m_pTableProperties->setText(iRow++, 2, i18n("For a fixed-size type, typlen is the number of bytes in the internal representation of the type. But for a variable-length type, typlen is negative. -1 indicates a \"varlena\" type (one that has a length word), -2 indicates a null-terminated C string."));
	
	//--- Not null
	m_pTableProperties->setText(iRow, 0, i18n("Not null"));
    m_pTableProperties->setPixmap(iRow, 1, m_pDomain->isNotNull() ? *KPGUtil::m_pIconTrue : *KPGUtil::m_pIconFalse);
	m_pTableProperties->setText(iRow++, 2, i18n("This represents a not-null constraint. It is possible to change this column to enable or disable the constraint."));
	
	//--- Default value
	m_pTableProperties->setText(iRow, 0, i18n("Default value"));
    m_pTableProperties->setText(iRow, 1, m_pDomain->defaultValue());
	m_pTableProperties->setText(iRow++, 2, i18n("A human-readable representation of the default value"));
	
	//--- Number of dimensions
	m_pTableProperties->setText(iRow, 0, i18n("Number of dimensions"));
    m_pTableProperties->setText(iRow, 1, QString("%1").arg(m_pDomain->typNDims()));
	m_pTableProperties->setText(iRow++, 2, i18n("Number of dimensions, if the domain is an array type; otherwise 0. (Presently, the number of dimensions of an array is not enforced, so any nonzero value effectively means \"it's an array\".) "));
	
	//--- Array delimiter
	m_pTableProperties->setText(iRow, 0, i18n("Array delimiter"));
    m_pTableProperties->setText(iRow, 1, m_pDomain->typDelim());
	m_pTableProperties->setText(iRow++, 2, i18n("Character that separates two values of this type when parsing array input. Note that the delimiter is associated with the array element data type, not the array data type."));
			
	//--- Owner
	m_pTableProperties->setText(iRow, 0, i18n("Owner"));
    m_pTableProperties->setText(iRow, 1, m_pDomain->owner());
	m_pTableProperties->setText(iRow++, 2, i18n("Owner of the domain"));
	
	for(int nCol = 0; nCol < 3; nCol++)
    {
        m_pTableProperties->adjustColumn(nCol);
    }
}

void KPGDomainPropPage::slotTablePropDblClicked(int iRow, int iCol, int, const QPoint &)
{
    QWidget *w = m_pTableProperties->cellWidget(iRow, iCol);
		if(w == 0)
			return;
					
		KPGLinkLabel *pLabel = static_cast <KPGLinkLabel *> (w);
		pqxx::oid _oid = pLabel->oid();
			
		if(_oid != 0)
			emit sigSearchObject(_oid);
}


// Consumes request for context menu for property table
void KPGDomainPropPage::slotTablePropContextMenuRequested(int row, int col, const QPoint & pos)
{
	emit sigTablePropContextMenuRequested(row, col, pos);	
}


#include "kpgdomainproppage.moc"
