//
// C++ Interface: kpgexecutorchildview
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGEXECUTORCHILDVIEW_H
#define KPGEXECUTORCHILDVIEW_H

#include <kmdichildview.h>

#include "kpgexecutor.h"

class KXMLGUIFactory;

class QBoxLayout;
class KPoGreView;
class KPGFunction;

/**
  * MDI child view for function executor
  *
  *	@author Lumir Vanek <lvanek@users.sourceforge.net>
  */
class KPGExecutorChildView : public KMdiChildView
{
	Q_OBJECT
public:
	KPGExecutorChildView(KPoGreView *, KXMLGUIFactory *, const PGSTD::string &, const QString &, KPGFunction *);
    ~KPGExecutorChildView();

	KPGExecutor* getExecutor() const { return m_pExecutor; }
	
	// Return true, if window can be closed
	bool requestClose();
	
private:
	// Function executor window
	KPGExecutor*	m_pExecutor;
	
	QBoxLayout* m_pLayout;
	KPoGreView* m_pPoGreView;

public slots:

	// Add KPGExecutor GUI client to factory
	void slotActivated();

	// Remove KPGExecutor GUI client from factory
	void slotDeactivated();
};

#endif
