//
// C++ Interface: kpgtype
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGTYPE_H
#define KPGTYPE_H

#include "kpgobject.h"

class KPGTypesFolder;

#include "../Wizards/kpgtablecolumnwizinfo.h"

/**
  * Item that represent data type.  
  *
  *
  * @author Lumir Vanek
  */
class KPGType : public KPGObject
{
public:
    KPGType(KPGTypesFolder *, const QString, pqxx::oid);
	KPGType(KPGTypesFolder *, KPGType *, const QString, pqxx::oid);
    ~KPGType();

	virtual eNodeType type() const { return nodeType; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "TYPE"; }
  	
	void setProperties(const pqxx::result::tuple &, const KPGConnection *pConnection);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
	
	const pqxx::result & resultAttributes() const { return m_pqxxResultAttributes; }
		
	/*
	 * Functions for accessing properties
	 */
	int typLen() const { return m_iTypLen; }
	bool byValue() const { return m_bByVal; }
    const QString & kind() const { return m_strKind; } // Type kind - e.g. base, composite, ...
    const QString & owner() const { return m_strOwner; }
    bool isDefined() const { return m_bIsDefined; }
	const QString & typDelim() const { return m_strTypDelim; }
	const QString & typAlign() const { return m_strTypAlign; }
	const QString & typStorage() const { return m_strTypStorage; }
	pqxx::oid oidTypElem() const { return m_oidTypElem; }
	const QString & element() const { return m_strElement; }
	pqxx::oid oidInputFunc() const { return m_oidInputFunc; }
	const QString & inputFunc() const { return m_strInputFunc; }
	pqxx::oid oidOutputFunc() const { return m_oidOutputFunc; }
	const QString & outputFunc() const { return m_strOutputFunc; }
	pqxx::oid oidTable() const { return m_oidTable; }
	const QString & tableName() const { return m_strTableName; }
    
    void fillListAttributes(KPGListTableColumns &, bool=false);
    
protected:
  	
  	/*
	 * Properties
	 */
	int m_iTypLen; 
	bool m_bByVal; 
	QString m_strKind;
	bool m_bIsDefined; 
	QString m_strTypDelim;
	QString m_strTypAlign;
	QString m_strTypStorage;
	pqxx::oid m_oidTypElem;
	QString m_strElement;
	pqxx::oid m_oidInputFunc;
	QString m_strInputFunc;
	pqxx::oid m_oidOutputFunc;
	QString m_strOutputFunc;
	pqxx::oid m_oidTable;
	QString m_strTableName;
	QString m_strOwner;
		
	// result that will be displayed in properties window
	pqxx::result m_pqxxResultAttributes;
};

#endif
