//
// C++ Interface: kpgcreateviewwidget2
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCREATEVIEWWIDGET2_H
#define KPGCREATEVIEWWIDGET2_H

#include "kpgcreateviewwidget2base.h"

#include "kpgcreateviewwizard.h"

class KPGDatabase; 

/**
Widget for create view Wizard

@author Lumir Vanek
*/

class KPGCreateViewWidget2 : public KPGCreateViewWidget2Base
{
Q_OBJECT
public:
    KPGCreateViewWidget2(QWidget *parent, const char *name, KPGDatabase *);
    ~KPGCreateViewWidget2();

	void setNamespace(const QString &strNamespace) { m_strNamespace = strNamespace; }
	
	void setMapTableNameAlias(const MapTableNameAlias &mapTableNameAlias)
	{
		m_MapTableNameAlias = mapTableNameAlias;
	}
	
	const QString getSQL() const;
	void refreshAvailColumnsList(const QString &);
		
protected slots:

	virtual void slotCheckBoxShowSysColumnsToggled(bool);
	virtual void slotComboBoxTableActivated(const QString &);
	virtual void slotColumnsSelectChanged(QListBoxItem*);
	virtual void slotViewColumnsSelectChanged(QListBoxItem*);
	virtual void slotColumnAdd();
	virtual void slotColumnDelete();
	virtual void slotColumnUp();
	virtual void slotColumnDown();

protected:
	bool m_bCheckBoxShowSysColumns;	
	KPGDatabase *m_pDatabase;
    QString m_strNamespace; // name of the namespace
    
    // Map of pair of <QString strTableName, QString strAlias> 	
    MapTableNameAlias m_MapTableNameAlias;
    		
signals:
	void sigEnableNextButton(bool);		
};

#endif
