//
// C++ Interface: kpgforeignkeyconstr
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGFOREIGNKEYCONSTR_H
#define KPGFOREIGNKEYCONSTR_H

#include "kpgtableconstraint.h"

class KPGTableConstraintsFolder;

/**
  * Table Foreign key constraint
  *
  * @author Lumir Vanek
  */
class KPGForeignKeyConstr : public KPGTableConstraint
{
public:
    KPGForeignKeyConstr(KPGTableConstraintsFolder *, const QString, pqxx::oid);
	KPGForeignKeyConstr(KPGTableConstraintsFolder *, KPGTableConstraint *, const QString, pqxx::oid);
    ~KPGForeignKeyConstr();
		
	virtual eNodeType type() const { return nodeForeignKeyConstr; }
	void setUpdType(const QString strUpdType) { m_strUpdType = strUpdType; }
	void setDelType(const QString strDelType) { m_strDelType = strDelType; }
	void setConstrKey(const QString strConstrKey) { m_strConstrKey = strConstrKey; }
	void setForeignKey(const QString strForeignKey) { m_strForeignKey = strForeignKey; }
	void setReferencedTable(pqxx::oid oidReferencedTable, const QString strReferencedTable) { m_oidReferencedTable = oidReferencedTable; m_strReferencedTable = strReferencedTable; }
				
	/*
	 * Functions for accessing properties
	 */			
	const QString & updType() const { return m_strUpdType; }
	const QString & delType() const { return m_strDelType; }
	const QString & constrKey() const { return m_strConstrKey; }
		
	pqxx::oid oidReferencedTable() const { return m_oidReferencedTable; }
	const QString & referencedTable() const { return m_strReferencedTable; }
	const QString & foreignKey() const { return m_strForeignKey; }
				
protected:

	/*
	 * Properties
	 */
	QString m_strUpdType;
	QString m_strDelType;
	QString m_strConstrKey;
		
	pqxx::oid m_oidReferencedTable;
	QString m_strReferencedTable;
	QString m_strForeignKey;
};

#endif
