//
// C++ Interface: kpgconversion
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGCONVERSION_H
#define KPGCONVERSION_H

#include "kpgobject.h"

class KPGConversionsFolder;

/**
Item that represent encoding conversion

@author Lumir Vanek
*/

class KPGConversion : public KPGObject
{
public:
    KPGConversion(KPGConversionsFolder *, const QString, pqxx::oid);
	KPGConversion(KPGConversionsFolder *, KPGConversion *, const QString, pqxx::oid);
    ~KPGConversion();

	virtual eNodeType type() const { return nodeConversion; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "CONVERSION"; }
  	
	void setProperties(const pqxx::result::tuple &);
	
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &) { return; }
	
	/*
	 * Functions for accessing properties
	 */
	bool isDefault() const { return m_bIsDefault; }
  	const QString & sourceEncoding() const { return m_strSourceEncoding; }
	const QString & destinationEncoding() const { return m_strDestinationEncoding; }
 	pqxx::oid oidConversionProcedure() const { return m_oidConversionProcedure; }
	const QString & conversionProcedure() const { return m_strConversionProcedure; }
	const QString & owner() const { return m_strOwner; }
	 
protected:
	
	/*
	 * Properties
	 */
	bool m_bIsDefault;
  	QString m_strSourceEncoding;
	QString m_strDestinationEncoding;
 	pqxx::oid m_oidConversionProcedure;
	QString m_strConversionProcedure;
	QString m_strOwner;
};

#endif
