#####################################################################
#
#	Author : Kushal Das
#	Copyright (c)  2006 Kushal Das
#	kushal@fedoraproject.org
#	
#	Copyright: See COPYING file that comes with this distribution
#
#
#####################################################################

from smtplib import *
import threading
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email.MIMEText import MIMEText
from email.Utils import COMMASPACE, formatdate
from email import Encoders
import os
import time
import math


class kdMail(threading.Thread):
	"""Class for accesssing SMTP server & sending the mails. It will use a new thread
	"""
	def __init__(self,files,data,parent):
		self.files = files
		self.parent = parent
		self.data=data
		threading.Thread.__init__ ( self )

		
	def run(self):
		try:
			self.smtpserver = SMTP(self.data['host'],self.data['port'])
			self.smtpserver .ehlo()
			if  self.smtpserver.has_extn('starttls'):
				self.smtpserver .starttls()
				self.smtpserver .ehlo()
			self.smtpserver .login(self.data['user'],self.data['password'])
			self.parent.progress(20)
			i = len(self.files)
			val = math.ceil(float(80) / i)
			currentProgress = 20
			for entry in self.files:
				self.parent.qApp.processEvents()
				self.sendMail(self.data['mail'],entry[0],entry[1],entry[2])
				currentProgress = currentProgress + val
				if currentProgress < 100:
					self.parent.progress(currentProgress)
				else:
					self.parent.progress(100)

			self.smtpserver .close()
			time.sleep(3)
			#self.parent.progressBar.reset()
			self.parent.message("Upload Successfull")
			self.parent.uploadBttn.setEnabled(1)
		except SMTPAuthenticationError:
			self.parent.message("Wrong Username/Password")
			self.parent.uploadBttn.setEnabled(1)
		except Exception:
			self.parent.message("Please check Server/Port ")
			self.parent.uploadBttn.setEnabled(1)
			
		
	def sendMail(self,to,file, subject, text):
		"""Function to send the mails
		"""
		msg = MIMEMultipart()
		msg['From'] = self.data['from']
		msg['To'] = to
		msg['Date'] = formatdate(localtime=True)
		msg['Subject'] = subject
		msg.attach( MIMEText(text) )
		part = MIMEBase('application', "octet-stream")
		part.set_payload( open(file,"rb").read() )
		Encoders.encode_base64(part)
		part.add_header('Content-Disposition', 'attachment; filename="%s"' % os.path.basename(file))
		msg.attach(part)
		self.smtpserver.sendmail(self.data['from'], to, msg.as_string() )




