//
// Copyright(C) 2007 Stefan Siegl <stesie@brokenpipe.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <QString>
#include <QStringList>

#include <klocalizedstring.h>

#include <kopeteonlinestatus.h>

#include "silcbuddycontact.h"
#include "silcchannelcontact.h"
#include "silcstatusfactory.h"
#include "silcprotocol.h"

static SilcStatusFactory *_self = NULL;

SilcStatusFactory::SilcStatusFactory()
{
}


SilcStatusFactory::~SilcStatusFactory()
{
}


SilcStatusFactory *
SilcStatusFactory::self(void)
{
  if(! _self)
    _self = new SilcStatusFactory();

  return _self;
}

enum {
  Op      = 1,
  Founder = 2,
  Quiet   = 4,
};

const Kopete::OnlineStatus &
SilcStatusFactory::getBuddyOnlineStatus(SilcChannelContact *ch,
					SilcBuddyContact *buddy)
{
  QStringList overlays;
  QStringList description;
  int weight_extra = 0;

  // push buddy's onlineStatus name (i.e. base status)
  Kopete::OnlineStatus base = buddy->onlineStatus();
  overlays << base.overlayIcons();
  description << base.description();

  if(ch->isOp(buddy)) {
    overlays << QString::fromLatin1("silc_op");
    description << i18n("Operator");
    weight_extra |= Op;
  }

  if(ch->isFounder(buddy)) {
    overlays << QString::fromLatin1("silc_founder");
    description << i18n("Founder");
    weight_extra |= Founder;
  }

  if(ch->isQuiet(buddy)) {
    overlays << QString::fromLatin1("silc_mute");
    description << i18n("Quiet");
    weight_extra |= Quiet;
  }

  QString key = overlays.join(QChar::fromAscii(':'));
  
  if(self()->_stats.contains(key))
    return *self()->_stats.value(key);

  // status not available yet
  QString desc = description.join(QString::fromLatin1(", "));
  Kopete::OnlineStatus *st =
    new Kopete::OnlineStatus(base.status(), base.weight() + weight_extra,
			     SilcProtocol::protocol(),
			     base.weight() + weight_extra, overlays,
			     desc, desc, NULL,
			     Kopete::OnlineStatusManager::HideFromMenu);

  self()->_stats.insert(key, st);
  return *st;
}
