/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef FORM_FIELDFACTORY_H
#define FORM_FIELDFACTorY_H

#include <QtCore/QString>

class QWidget;

namespace Form
{

class Field;

class FieldFactory
{
  public:
    ~FieldFactory();

    static FieldFactory *self();

    /**
     * Returns a new field of the given type or 0 if the type is
     * unknown to the factory.
     */
    Field *createField( const QString &type, const QString &name, QWidget *parent ) const;

  private:
    FieldFactory();

    static FieldFactory *mSelf;
};

}

#endif
