ALTER TABLE `content` ADD `type` varchar(255) DEFAULT 'text' NOT NULL;
ALTER TABLE `content` ADD `title` varchar(255) default NULL;
ALTER TABLE `content` ADD `lastupdatedby` int(11) NOT NULL default '0';
ALTER TABLE `content` ADD `lastupdated` timestamp NOT NULL;
ALTER TABLE `tree` ADD `alias` varchar(255) DEFAULT '' NOT NULL;
ALTER TABLE `tree` ADD `contentcollapsed` int(1) NOT NULL DEFAULT '0';
ALTER TABLE `content` CHANGE `content` `content` MEDIUMTEXT NOT NULL;
ALTER TABLE `users` CHANGE `password` `password` VARCHAR(32) NOT NULL;
ALTER TABLE `tree` ADD `subinheritrights` int(1) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinheritrightseditable` int(1) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinheritrightsdisable` int(1) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinheritowner` int(11) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinheritgroup` int(11) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinherituserrights` int(11) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinheritgrouprights` int(11) NOT NULL default '0';
ALTER TABLE `tree` ADD `subinheritotherrights` int(11) NOT NULL default '0';

CREATE TABLE `extensions` (
`id` INT NOT NULL AUTO_INCREMENT ,
`keyname` VARCHAR( 255 ) NOT NULL ,
`active` INT NOT NULL ,
`admin` INT NOT NULL DEFAULT '0',
`version` VARCHAR(30) NOT NULL DEFAULT '',
PRIMARY KEY ( `id` ),
KEY `active` (`active`)
);

CREATE TABLE `settings` (
`id` INT NOT NULL AUTO_INCREMENT ,
`name` VARCHAR( 255 ) NOT NULL ,
`value` VARCHAR( 255 ) NOT NULL ,
`description` VARCHAR( 255) NOT NULL DEFAULT '',
`selection` VARCHAR(255) NOT NULL DEFAULT '',
PRIMARY KEY ( `id` ) ,
UNIQUE (
`name`
)
);

CREATE TABLE `content_open` (
	`id` int(11) NOT NULL auto_increment,
	`contentid` int(11) NOT NULL default '0',
	`userid`varchar(32) NOT NULL default '',
	`opened` int(11) NOT NULL default '0',
	PRIMARY KEY  (`id`),
	KEY `contentid` (`contentid`),
	KEY `userid` (`userid`)
) TYPE=MyISAM AUTO_INCREMENT=1 ;

CREATE TABLE `users_login` (
  `usersid` int(10) unsigned NOT NULL default '0',
  `login_trial` int(10) unsigned NOT NULL default '0',
  `lasttrydate` int(11) unsigned NOT NULL default '0',
  `session_id` varchar(100) NOT NULL default '',
  UNIQUE KEY `usersid` (`usersid`)
);

# Enable extensions
INSERT INTO `extensions` (`keyname`, `active`, `admin`) VALUES ('admin_extension', 1, 1);
INSERT INTO `extensions` (`keyname`, `active`, `admin`) VALUES ('admin_info', 1, 1);
# INSERT INTO `extensions` (`keyname`, `active`, `admin`) VALUES ('admin_install', 1, 1);
# INSERT INTO `extensions` (`keyname`, `active`, `admin`) VALUES ('admin_update', 1, 1);
INSERT INTO `extensions` (`keyname`, `active`, `admin`) VALUES ('admin_config', 1, 1);

# insert default settings
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('login.delay', '30', 'setting login delay', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('login.max', '50', 'setting max login', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.charset', 'UTF-8', 'set charset', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.language', 'en', 'set default language', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.language_dropdown', '0', 'show language dropdown', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.1', 'en', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.2', 'de', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.3', 'pt-br', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.4', 'nl', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.5', 'ja', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.6', 'es', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.availablelanguages.7', 'ru', '', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.use', '1', 'enable rte editor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.editor', 'fckeditor', 'choose fckeditor or tinymce', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.tinymce.cols', '75' , 'set cols for textarea in tinymce', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.tinymce.rows', '20', 'set rows for textarea in tinymce', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.fckeditor.width', '600', 'set widht of fckeditor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.fckeditor.height', '450', 'set height of fckeditor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.fckeditor.langdefault', 'en', 'set default lang in default fckeditor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.fckeditor.langdetect', 'false', 'enable autodetection of language in fckeditor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.fckeditor.toolbar', 'Default', 'choose toolbar in fckeditor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('htmleditor.fckeditor.skin', 'default', 'choose skin in fckeditor', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.title', 'Knowledgeroot', 'set title for knowledgeroot', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('menu.expandall', '1', 'expand menu at default', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('menu.type', 'static', 'set menu type', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('menu.ajax', 'yes', 'use ajax menu', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.default_theme', 'green', 'set theme in knowledgeroot', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.showtitle', 'yes', 'show title of contents', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.collapsecontent', 'yes', 'enable collapse content', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.showlastupdated', 'yes', 'show lastupdate of content', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.uploadfolder', 'uploads/', 'set upload folder', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.uploadserverpath', 'auto', 'set upload server path', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.defaultpage', '', 'set id of default page', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.notification', '0', 'enable email notification', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.recipients', '', 'set recipients', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.type', 'html', 'enable html mails', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.from_name', 'Knowledgeroot', 'set from name', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.from_email', 'knowledgeroot@mydomain.tld', 'set from email', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.smtp_mode', '0', 'enable to use smtp instead of mail', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.smtp_host', '', 'set smtp host', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.smtp_port', '25', 'set port of host', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.smtp_username', '', 'set username for authentification', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('email.smtp_password', '', 'set password for authentification', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('dev.toolbar', '0', 'show developer toolbar', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('pagealias.use', '1', 'enable pagealias', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('pagealias.rights', '2', 'set rights to edit the alias', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('pagealias.static', '0', 'enable of using static links', '');
INSERT INTO `settings` (`name`, `value`, `description`, `selection`) VALUES ('knowledgeroot.maxfilesize', '5242880', 'set maxfilesize for uploads', '');

# setting indexes
ALTER TABLE `content` ADD INDEX ( `belongs_to` );
ALTER TABLE `content` ADD INDEX ( `owner` );
ALTER TABLE `content` ADD INDEX ( `group` );
ALTER TABLE `content` ADD INDEX ( `userrights` );
ALTER TABLE `content` ADD INDEX ( `grouprights` );
ALTER TABLE `content` ADD INDEX ( `otherrights` );
ALTER TABLE `content` ADD INDEX ( `deleted` );

ALTER TABLE `files` ADD INDEX ( `belongs_to` );
ALTER TABLE `files` ADD INDEX ( `deleted` );

ALTER TABLE `groups` ADD INDEX ( `deleted` );

ALTER TABLE `tree` ADD INDEX ( `belongs_to` );
ALTER TABLE `tree` ADD INDEX ( `owner` );
ALTER TABLE `tree` ADD INDEX ( `group` );
ALTER TABLE `tree` ADD INDEX ( `userrights` );
ALTER TABLE `tree` ADD INDEX ( `grouprights` );
ALTER TABLE `tree` ADD INDEX ( `otherrights` );
ALTER TABLE `tree` ADD INDEX ( `deleted` );

ALTER TABLE `user_group` ADD INDEX ( `userid` );
ALTER TABLE `user_group` ADD INDEX ( `groupid` );

ALTER TABLE `users` ADD INDEX ( `password` );
ALTER TABLE `users` ADD INDEX ( `deleted` );
