// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.63 $
#include "hk_class.h"
#include <hk_kdegrid.h>
#include <hk_kdegrid.moc>
#include <hk_kdesimplegrid.h>
#include <hk_kderowselector.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qdrawutil.h>
#include <qscrollbar.h>
#include <qsizepolicy.h>
#include <hk_kdesimpleform.h>
#include "hk_dsgridcolumn.h"
#include "hk_kdefinddialog.h"
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qcstring.h>
//#include "hk_kdegridpartfactory.h"

#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>

//*******************************
//***       hk_kdegrid        ***
//*******************************

hk_kdegrid::hk_kdegrid(QWidget* wid,const char* n,WFlags f,hk_kdesimpleform* form)
: QFrame(wid,n,f) ,hk_dsgrid(form)
{
#ifdef HK_DEBUG
//wanna_debug(true);
    hkdebug("hk_kdegrid::hk_kdegrid");
#endif
    QSizePolicy policy(QSizePolicy::Expanding,QSizePolicy::Expanding);
    QSizePolicy fixedpolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
    QSizePolicy labelpolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
    if (wid!=NULL)setFrameStyle(Box|Sunken);
    hbottomlayout= new QHBoxLayout;
    hdatalayout=new QHBoxLayout;
    htoplayout=new QHBoxLayout;
    vbasiclayout  = new QVBoxLayout(this,3,0,0);
    statusbar    = new QLabel(this);
    p_grid=NULL;
    p_grid        = new hk_kdesimplegrid(this,statusbar,form);
    setFocusProxy(p_grid);
    selector  = new hk_kderowselector(this,form);
    selector->setFocusPolicy(ClickFocus);
    setFocusPolicy(StrongFocus);
    selector->setSizePolicy(fixedpolicy);
    statusbar->setSizePolicy(labelpolicy);
    p_grid->setSizePolicy(policy);
    vbasiclayout->addLayout(htoplayout,0);
    vbasiclayout->addLayout(hdatalayout,1);
    vbasiclayout->addLayout(hbottomlayout,0);
//   vheader->setOrientation(QHeader::Vertical);
    int hbheight= 20;
    hdatalayout->addWidget(p_grid);
    hbottomlayout->addWidget(selector);
    hbottomlayout->addWidget(statusbar);
    hbottomlayout->setEnabled(true);
    statusbar->setFrameStyle(WinPanel|Sunken);
    statusbar->setMidLineWidth(0);
    statusbar->setLineWidth(1);
    statusbar->setText("STATUS");
    selector->setMaximumHeight(hbheight);
    selector->setMaximumWidth(240);
    selector->setMinimumWidth(240);
    selector->setMinimumHeight(hbheight);
    statusbar->setMaximumHeight(hbheight);
    vbasiclayout->setEnabled(true);
    vbasiclayout->activate();
//   grid->set_headers(hheader,vheader,statusbar);
//   grid->set_rowselector(selector);
    p_visibletype=hk_visible::grid;
    p_finddialog=NULL;
    p_findfirstview=true;
    p_part=NULL;
    QColor qcolor=p_grid->paletteBackgroundColor();
    hk_colour colour(qcolor.red(),qcolor.green(),qcolor.red());
    if (p_presentation)set_backgroundcolour(colour,false,true);
    qcolor=p_grid->paletteForegroundColor();
    colour.set_colour(qcolor.red(),qcolor.green(),qcolor.red());
    if (p_presentation)set_foregroundcolour(colour,false,true);
    widget_specific_font_changed();
}


hk_kdegrid::~hk_kdegrid()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdegrid::~hk_kdegrid");
#endif
    p_presentation=NULL;

}


void hk_kdegrid::set_datasource(hk_datasource* d)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdegrid::datasource(hk_datasource* d)");
#endif
    p_grid->set_datasource(d);
    selector->set_datasource(d);
    hk_dsgrid::set_datasource(d);
}


bool hk_kdegrid::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdegrid::widget_specific_coordinates");
#endif
    unsigned int ppx=px;
    unsigned int ppy=py;
    unsigned int ppw=pwidth;
    unsigned int pph=pheight;
    if (p_presentation!=NULL)
    {

        ppx=p_presentation->horizontal2relativ(ppx);
        ppy=p_presentation->vertical2relativ(ppy);
        pph=p_presentation->vertical2relativ(pph);
        ppw=p_presentation->horizontal2relativ(ppw);

    }
    blockSignals(true);
    setGeometry(px,py,pwidth,pheight);
    if (p_presentation!=NULL) p_grid->set_size(ppx,ppy,ppw,pph,false);
    blockSignals(false);
    return true;
}


void hk_kdegrid::widget_specific_presentationdatasource(long n)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdegrid::widget_specific_presentationdatasource");
#endif

// hk_dsvisible::presentationdatasource(n);

    p_grid->set_presentationdatasource(n,false);
    selector->set_presentationdatasource(n,false);

}


void hk_kdegrid::widget_specific_enable_disable(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdegrid::widget_specific_enable_disable");
#endif
    if (p_presentation!=NULL)
        if (p_presentation->mode()==hk_form::designmode)
    {
//setFocusPolicy(NoFocus);
        setEnabled(true);
    }
    else
    {
    setFocusPolicy(StrongFocus);
    widget_specific_rowheight_changes();
    }

}


void hk_kdegrid::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("kdegrid::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QFrame::x()):QFrame::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QFrame::y()):QFrame::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QFrame::height()):QFrame::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QFrame::width()):QFrame::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}

void hk_kdegrid::widget_specific_columns_created(void)
{
p_grid->columns_created();
}

void hk_kdegrid::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("kdegrid::resizeEvent");
#endif
    QFrame::resizeEvent(event);
    reposition();

}


void  hk_kdegrid::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("kdegrid::resizeEvent");
#endif
    QFrame::moveEvent(event);
    reposition();
}


void hk_kdegrid::find_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("kdegrid::find_clicked");
#endif
    if (p_finddialog==NULL)
    {
        p_finddialog=new hk_kdefinddialog(this,0,false);
        connect(p_finddialog, SIGNAL(signal_findbutton_clicked()),this,SLOT(find_next()));
        connect(p_finddialog, SIGNAL(signal_findargument_changed()),this,SLOT(findargument_changed()));
    }

    p_findfirstview=true;
    findargument_changed();
    p_finddialog->show();
}


void    hk_kdegrid::find_next(void)
{
#ifdef HK_DEBUG
    hkdebug("kdegrid::find_next");
#endif
    bool search=true;
    if (p_finddialog==NULL)return;
    while (search)
    {
        if (p_finddialog->all_columnsbox->isChecked())
        {
            cout <<"noch nicht eingebaut"<<endl;
            search=false;
        }

        else
        {
            //hk_column* c= p_grid->actual_column();
            //if (c==NULL) return;
            unsigned int from=0;
            unsigned int to=0;
            if (p_finddialog->find_backwardsbox->isChecked())
            {

                from=0;
                to=((datasource()->row_position()>0)&&!p_findfirstview)?
                    datasource()->row_position()-1:
                (p_findfirstview?datasource()->row_position():datasource()->max_rows()-1);
            }
            else
            {
                from=((datasource()->row_position()<datasource()->max_rows()-2)&&!p_findfirstview)?
                    datasource()->row_position()+1:
                (p_findfirstview?datasource()->row_position():0);
                to=datasource()->max_rows()-1;
            }

            unsigned int r=gridcolumn(p_grid->currentColumn())->find( from,
                to,
                u2l(p_finddialog->searchfield->currentText().utf8().data()),
                !p_finddialog->part_of_columnbox->isChecked(),
                p_finddialog->case_sensitivebox->isChecked(),
                p_finddialog->find_backwardsbox->isChecked()
                );
            if (r<datasource()->max_rows())
            {
                datasource()->goto_row(r);
		p_grid->clearSelection();
		p_grid->selectRow(r);
                search=false;
            }
            else
            {
                if (!p_findfirstview)
                {
                    show_warningmessage(hk_translate("Not found."));
                    search=false;
                    return;
                }
                else
                {
                    datasource()->goto_first();
                }

            }
        }

        p_findfirstview=false;
    }

}


void hk_kdegrid::findargument_changed(void)
{
    p_findfirstview=true;

}


void  hk_kdegrid::before_row_change(void)
{
   hk_dsgrid::before_row_change();
    p_grid->before_row_change();
}


void hk_kdegrid::widget_specific_font_changed(void)
{
    setFont(QFont(QString::fromUtf8 (l2u(hk_dsgrid::font().fontname()).c_str())
                  ,hk_dsgrid::font().fontsize(),hk_dsgrid::font().bold()?QFont::Bold:QFont::Normal,
		   hk_dsgrid::font().italic()));
//    statusbar->setFont(QFont(QString::fromUtf8 (l2u(p_font).c_str()),p_fontsizeint));
}


void hk_kdegrid::print_grid(void)
{

    p_grid->print_grid();

}


void    hk_kdegrid::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    if (!p_grid->presentation())return;
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    p_grid->setPaletteBackgroundColor(newcolour);
    setPaletteBackgroundColor(newcolour);
}


void    hk_kdegrid::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    if (!p_grid->presentation())return;
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    p_grid->setPaletteForegroundColor(newcolour);
    setPaletteForegroundColor(newcolour);
}


void hk_kdegrid::widget_specific_rowheight_changes(void)
{
if (p_grid)p_grid->widget_specific_rowheight_changes();
}


void hk_kdegrid::show_widget(void)
{
  show();
}

void hk_kdegrid::hide_widget(void)
{
  hide();
}

bool hk_kdegrid::close_widget(void)
{
  return close();
}


bool hk_kdegrid::presentationmode_changed()
{
if (!p_presentation)
  {
    setEnabled(is_enabled());
    return hk_dsgrid::presentationmode_changed();
  }
bool result=hk_dsgrid::presentationmode_changed();
  if (p_presentation->mode()==hk_presentation::filtermode)
  {
   setEnabled(false);
   if (p_grid)p_grid->setEnabled(false);
  }
  else
   setEnabled(is_enabled());
  return  result;
}
