/***************************************************************************
                          accel.cpp  -  description
                             -------------------
    begin                : Wed Nov 6 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "accel.moc"
#include <klocale.h>

Accel::Accel( QWidget *parent, QObject *target ) : KAccel( parent )
{
	insertItem( i18n("Previous Move"), "Previous Move", Key_Up, TRUE );
	insertItem( i18n("Next Move"), "Next Move", Key_Down, TRUE );
	insertItem( i18n("Enter Text"), "Enter Text", Key_Return, TRUE );
	insertItem( i18n("Page Up"), "Page Up", Key_PageUp, TRUE );
	insertItem( i18n("Page Down"), "Page Down", Key_PageDown, TRUE );
	insertItem( i18n("Increase Board Size"), "Board Up", ALT + Key_Plus, TRUE );
	insertItem( i18n("Decrease Board Size"), "Board Down", ALT + Key_Minus, TRUE );
	insertItem( i18n("Last History Item"), "Last History Item", SHIFT + Key_Up, TRUE );
	insertItem( i18n("Next History Item"), "Next History Item", SHIFT + Key_Down, TRUE );
	insertItem( i18n("Reply to the Last Tell"), "Tell Reply", ALT + Key_R, TRUE );
	insertItem( i18n("Reply to the Channel"), "Channel Reply", ALT + Key_C, TRUE );
	insertItem( i18n("Kibitz"), "Kibitz", ALT + Key_K, TRUE );
	insertItem( i18n("Whisper"), "Whisper", ALT + Key_W, TRUE );
	readSettings();

	if( target )
		setTarget( target );
}
Accel::~Accel()
{
	writeSettings();
}
void Accel::setTarget( QObject *target )
{
	connectItem( "Board Down" , target, SIGNAL( board_down() ) );
	connectItem( "Board Up" , target, SIGNAL( board_up() ) );
	connectItem( "Previous Move" , target, SIGNAL( move_prev() ) );
	connectItem( "Next Move" , target, SIGNAL( move_next() ) );
	connectItem( "Page Up", target, SIGNAL( page_up() ) );
	connectItem( "Page Down", target, SIGNAL( page_down() ) );
	connectItem( "Last History Item", target, SIGNAL( history_prev() ) );
	connectItem( "Next History Item", target, SIGNAL( history_next() ) );
	connectItem( "Tell Reply", target, SIGNAL( reply_tell() ) );
	connectItem( "Channel Reply", target, SIGNAL( reply_channel() ) );
	connectItem( "Enter Text", target, SIGNAL( focus() ) );
	connectItem( "Kibitz", target, SIGNAL( kibitz() ) );
	connectItem( "Whisper", target, SIGNAL( whisper() ) );
}
