/***************************************************************************
                          kbackupdialog.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Michael Edwardes
    email                : mte@users.sourceforge.net
                             Javier Campos Morales <javi_c@ctv.es>
                             Felix Rodriguez <frodriguez@mail.wesleyan.edu>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// ----------------------------------------------------------------------------
// QT Includes

#include <qpixmap.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcheckbox.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <kglobal.h>
#include <klocale.h>
#if QT_VERSION > 300
#include <kstandarddirs.h>
#else
#include <kstddirs.h>
#endif

#include <kconfig.h>
#include <kdirselectdialog.h>
#include <kglobalsettings.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <kguiitem.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kbackupdlg.h"

KBackupDlg::KBackupDlg( QWidget* parent,  const char* name/*, bool modal*/)
  : kbackupdlgdecl( parent,  name , true)
{
  readConfig();

  // add icons to buttons
  KIconLoader *il = KGlobal::iconLoader();
  KGuiItem okButtenItem( i18n("&Ok" ),
                    QIconSet(il->loadIcon("button_ok", KIcon::Small, KIcon::SizeSmall)),
                    i18n("Start the backup operation"),
                    i18n("Pressing this button starts the backup operation."));
  btnOK->setGuiItem(okButtenItem);

  KGuiItem cancelButtenItem( i18n( "&Cancel" ),
                    QIconSet(il->loadIcon("button_cancel", KIcon::Small, KIcon::SizeSmall)),
                    i18n("Cancel the backup operation"),
                    i18n("Use this to abort the backup and to return to KMyMoney."));
  btnCancel->setGuiItem(cancelButtenItem);

  KGuiItem chooseButtenItem( i18n("C&hoose..."),
                    QIconSet(il->loadIcon("folder", KIcon::Small, KIcon::SizeSmall)),
                    i18n("Select mount point"),
                    i18n("Use this to browse to the mount point."));
  chooseButton->setGuiItem(chooseButtenItem);
  
  connect(chooseButton, SIGNAL(clicked()), this, SLOT(chooseButtonClicked()));
  connect(btnOK,SIGNAL(clicked()),this,SLOT(accept()));
  connect(btnCancel,SIGNAL(clicked()),this,SLOT(reject()));
}

KBackupDlg::~KBackupDlg()
{
  writeConfig();
}

void KBackupDlg::chooseButtonClicked()
{
  KURL newDir = KDirSelectDialog::selectDirectory(KGlobalSettings::documentPath());
  if (newDir.hasPath())
    txtMountPoint->setText(newDir.path());
}

void KBackupDlg::readConfig(void)
{
  KConfig *config = KGlobal::config();
  config->setGroup("Last Use Settings");
  mountCheckBox->setChecked(config->readBoolEntry("KBackupDlg_mountDevice", false));
  txtMountPoint->setText(config->readEntry("KBackupDlg_BackupMountPoint", "/mnt/floppy"));
}

void KBackupDlg::writeConfig(void)
{
  KConfig *config = KGlobal::config();
  config->setGroup("Last Use Settings");
  config->writeEntry("KBackupDlg_mountDevice", mountCheckBox->isChecked());
  config->writeEntry("KBackupDlg_BackupMountPoint", txtMountPoint->text());
  config->sync();
}

#include "kbackupdlg.moc"
