/***************************************************************************
                          contactextension.h  -  description
                             -------------------
    begin                : Thu 12 Dec 2002
    copyright            : (C) 2003 by Michael Curtis
    email                : mdcurtis@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTACTEXTENSION_H
#define CONTACTEXTENSION_H

#include <qobject.h>

#include <kapp.h>

#include "contactbase.h"

// forward declarations
class Contact;
class KConfig;

/**
 * The class stores "extended" info for a contact, such as an alternative friendlyName
 * @author Michael Curtis
 */

class ContactExtension : public QObject
{
  Q_OBJECT

  public:
    // The constructor with specified contact handle
    	                     ContactExtension(QString handle);
    // The destructor
    	                    ~ContactExtension();

    // Read property of QString alternativeName_.
    const QString &       getAlternativeName() const;
    // Read property of QString pictureFile_.
    const QString          getContactPicturePath() const;
    // Read property of QString soundFile_.
    const QString          getContactSoundPath() const;
    // Read property of bool notifyOnline_
    bool                   getNotifyOnline() const;
    // Read property of bool useAlternativeName_.
    bool                   getUseAlternativeName() const;
     // Load extension settings for a contact
    void                   readProperties(KConfig *config);
    // Save extension settings for a contact
    void                   saveProperties(KConfig *config);
    // Write property of QString alternativeName_.
    void                   setAlternativeName( const QString& _newVal );
    // Write property of QString pictureFile_.
    void                   setContactPicturePath( const QString& _newVal );
    // Write property of QString soundFile_.
    void                   setContactSoundPath( const QString& _newVal );
    // Write property of bool notifyOnline_
    void                   setNotifyOnline( bool _newVal );
    // Write property of bool useAlternativeName_;
    void                   setUseAlternativeName( bool _newVal );


  private: // Private attributes
    // The alternative name
    QString                alternativeName_;
    // The contact's handle (ie email)
    QString                handle_;
    // Whether or not to notify online/offline status
    bool                   notifyOnline_;
    // A picture used for the "contact is online" balloons
    QString                pictureFile_;
    // A sound played when the contact is online
    QString                soundFile_;
    // Whether or not we should use the alternative name stored in the class
    bool                   useAlternativeName_;

  signals: // Signals
    // Notifiy any watchers that this contact's information has been changed.
    void                   changedFriendlyName();
    // Signal that the contact's picture path has changed
    void                   changedPicture();

};
#endif
