#ifndef __SFPREVIEW_H__
#define __SFPREVIEW_H__

#include <sndfile.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "sfpreview.h"

void sfpreview_update(GtkFileChooser* filechooser, gpointer data){
	GtkWidget *sfp = (GtkWidget*) data;
	SF_INFO*   sfinfo = (SF_INFO*) malloc(sizeof(SF_INFO));
	SNDFILE*   sf = NULL;
	char      *filename;
	char	  *txt = malloc(sizeof(char) * 256);

	filename = gtk_file_chooser_get_preview_filename(filechooser);
	if (filename) sf = sf_open (filename, SFM_READ, sfinfo);
	if (sf != NULL){
		sprintf(txt,"%.1f seconds %s, %d hz",
			(float)((float)sfinfo->frames / (float)sfinfo->samplerate),
			(sfinfo->channels == 1) ? "mono" : "stereo",
			(int)sfinfo->samplerate);

/*		printf ("%s\n",txt);	*/
		if (txt) gtk_label_set_label((GtkLabel*)sfp,txt);

		gtk_file_chooser_set_preview_widget_active (
			filechooser,TRUE);
		sf_close(sf);
	}else{
		gtk_label_set_label((GtkLabel*)sfp,"no info");
		gtk_file_chooser_set_preview_widget_active (
			filechooser,TRUE);
	}
	free(txt);
}

GtkWidget *sfpreview_new(){
	GtkWidget *sfp = gtk_label_new ("no info");
	gtk_label_set_angle((GtkLabel*)sfp,90);
/*	gtk_label_set_ellipsize((GtkLabel*)sfp,PANGO_ELLIPSIZE_MIDDLE);*/
	gtk_label_set_use_underline ((GtkLabel*)sfp,FALSE);
	gtk_label_set_single_line_mode ((GtkLabel*)sfp,FALSE);
	gtk_widget_show(sfp);
	return sfp;
}

#endif
