/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _SCANVIEWER_H_
#define _SCANVIEWER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include "k3bjobprogressosd_mod.h"


class KPrinter;
class KToggleAction;
class KURL;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QListBox;
class QListView;
class QListViewItem;
class QPushButton;
class QLabel;
class KProcIO;
class KConfig;
class KURLRequester;
class KProgress;
class K3bJobProgressOSD;
class KProgressDialog;
class QDir;
class QGridLayout;

/**
 * This class serves as the main window for ScanViewer.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class ScanViewer  : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ScanViewer(QWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~ScanViewer();

    /**
     * Use this method to load whatever file/URL you have
     */
    
    //void  setDirName(QString);
    void slotScan(const QStringList & filepattern, int mode, bool recursive, bool dcopscan);
    void slotCancel();
    void slotStartAgain();
    bool scanGoingOn();

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(KConfig *);


private slots:

    void slotProg();
    void slotOnItem( QListViewItem * lineitem);
    void slotOffItem();
private:
    void setupAccel();
    void setupActions();
    void startProgressDialog( const QString & text );

private:

signals:
    void itemSelected(QString abs_filename, int line);
    void scanFinished(QWidget *);
    void scanStartingAgain(QWidget *);
public slots:


private slots:
    //void dirButtonClicked();
    //void templateActivated(int index);
    void childExited();
    void resetSysTray();
    void receivedOutput(KProcIO *);
    //void itemSelected(const QString&);
    void slotClear();
    void slotRMB( QListViewItem *, const QPoint &, int );
    void slotQuarantineSelected();
    void slotVirusPool();
    void slotVirusList();
    void slotGoogle();
    void slotTrendMicro();
	void slotCancelScanTime();
    //void patternTextChanged( const QString &);
private:
    void processOutput();
    void finish();
    void getout();
    void Quarantine();
    void askUser();
    int countFiles( QDir & root);
    //void ScanViewer::startProgress();
    QLineEdit *template_edit;
    QComboBox *files_combo, *pattern_combo, *check_combo;
    //KComboBox *dir_combo;
    QCheckBox *recursive_box;
    QCheckBox *recursive_box2;
    QListView *resultview;
    QPushButton *search_button, *cancel_button;
    QLabel *status_label, *status2_label,*matches_label,*matches2_label;
    KProcIO *childproc;
    QString buf;
    KConfig* config;
    QStringList lastSearchItems;
    QStringList lastScanPaths;
    QStringList lastQuarItems;
    QStringList QuarantineList;
    bool errorsEncountered;
    QPopupMenu* menu;
    QPushButton* adv_options;
    QPushButton* schedule;
    QString selectedVirus;
    bool multiScan;
    QString urlsToScan;
    bool scanInProgress;
    bool scanCancelled;
    QString prevdir;
    QStringList listOfUrlsToScan;
    bool multi_recursive;
    int m_mode;
    QStringList m_filepattern;
    bool m_recursive;
    int filesscanned;
    int cnt;
    KProgressDialog* progress;
    KProgress* prog;
    K3bJobProgressOSD* progosd;
    QBoxLayout *status2_layout;
    QFrame *status2_frame;
    QGridLayout *layout;
    KProgressDialog *progressDialog;
    QTimer *timer;
	QPushButton* scan_time;
	bool calculateTime;
	bool showProgress;
    QFrame *status_frame;
};

#endif // _SCANVIEWER_H_
