/***************************************************************************
 *   Copyright (C) 2005 by KesieV   *
 *   kesiev@hotmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kitty_nekotongue.h"
#include <kwizard.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <keditlistbox.h>
#include <kdialog.h>
#include <kpushbutton.h>
#include <khtml_part.h>
#include <khtmlview.h>
#include <qpixmap.h>
#include <kstandarddirs.h>
#include <qcheckbox.h>

kitty_nekotongue::kitty_nekotongue(int mode,Kitty *main,QWidget *parent, const char *name)
 : KWizard( parent, name, TRUE)
{
	mainwindow=main;
	QPixmap sideimg=QPixmap(locate("appdata", "neko-side.png"));
	localsettings=kitty_globals::settings;

	page2=new QHBox(this);
	QLabel *side2=new QLabel("",page2);
	side2->setPixmap(sideimg);
	side2->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
	QHBox *page2v=new QVBox(page2);
	page2->setSpacing(KDialog::spacingHint());
	page2v->setSpacing(KDialog::spacingHint());
	new QLabel(i18n("Let's check your tastes!<br>Add and order here all the words that match your tastes.<br><br><b>For example:</b> if you are a mac fan, you can put <i>mac, apple</i> in your taste list."),page2v);
	tastes=new KEditListBox(i18n("Tasty words list"),page2v);
	tastes->insertStringList(kitty_globals::tastes);
	new QLabel(i18n("<b>Notes:</b> the tastywords' length limit is 20."),page2v);
	connect(tastes,SIGNAL(changed()),this,SLOT(changeTastes()));

	page3=new QHBox(this);
	QLabel *side3=new QLabel("",page3);
	side3->setPixmap(sideimg);
	side3->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);	QHBox *page3v=new QVBox(page3);
	page3->setSpacing(KDialog::spacingHint());
	page3v->setSpacing(KDialog::spacingHint());
	new QLabel(i18n("Here your results!"),page3v);
    	tasteml=new KHTMLPart(page3v);
	new QLabel(i18n("Click on <b>Tune in</b> to add channels."),page3v);
	connect( tasteml->browserExtension(),
        SIGNAL( openURLRequest( const KURL &, const KParts::URLArgs & ) ),
        this, SLOT( openURLRequest(const KURL &, const KParts::URLArgs & ) ) );

	if (mode==1) {
		
		setCaption(i18n("Welcome to Kitty!"));
		QPixmap sideimgw=QPixmap(locate("appdata", "neko-side-welcome.png"));

		welc1=new QHBox(this);
		QLabel *sidew1=new QLabel("",welc1);
		sidew1->setPixmap(sideimgw);
		sidew1->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		welc1->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("<h2>Welcome to Kitty!</h2><br>Kitty is a podcast client for the KDE environment. You can watch <i>about</i> all internet TV and podcasts channels avaible over the net.<br>With Kitty you can choose your channels from searchable <i>channel guides</i>, watch and read contents for each TV-program and put media into your personal collection for watching videos offline as many times as you want!<br><br>But there is something more... Click <b>Next</b> and have fun!"),welc1);

		welc2=new QHBox(this);
		QLabel *sidew2=new QLabel("",welc2);
		sidew2->setPixmap(sideimgw);
		sidew2->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		welc2->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("First of all, let's check your tastes!<br><br>Kitty will search for you something interesting into the Kitty's TV guide, asking you just some random words that match your interests.<br>This tool is called <b>NekoTongue</b> and will be ever avaible on your <b>Feed</b> menu.<br>Check NekoTongue many times from now on, since the Kitty's channel guide is still growing..."),welc2);

		welc3=new QHBox(this);
		QLabel *sidew3=new QLabel("",welc3);
		sidew3->setPixmap(sideimgw);
		sidew3->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		welc3->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("Well done! I think that now you have a bunch of channels on your subscribed list.<br><br>What?<br><br>Found <i>anything</i>?<br><br>Don't worry. After this wizard, you can check the \"DTV\" or \"Yahoo! Podcast\" guide, search the Kitty's guide manually or retry searching channels with NekoTongue! ;) <i>(Sorry!)</i><br><br>Now let's configure the program..."),welc3);

		welc4=new QHBox(this);
		QLabel *side4=new QLabel("",welc4);
		side4->setPixmap(sideimgw);
		side4->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		QHBox *welc4v=new QVBox(welc4);
		welc4->setSpacing(KDialog::spacingHint());
		welc4v->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("Kitty can do something automatically for you. Let's see what...<br><br>When you click a channel, Kitty can automatically download his current programs list and show you what's on.<br>If you turn off this option, you must click on <b>Refresh current feed</b> from the <b>Feed</b> menu or into the contextual menu of the feed list."),welc4v);
    		chk_open_on_click=new QCheckBox(i18n("Autorefresh empty feeds on click."),welc4v);
		chk_open_on_click->setChecked(localsettings.set_open_on_click);
		new QLabel(i18n("Programs can be bookmarked into your <b>Media collection</b>. That stuff will remain on your PC and can be removed manually. You can tell to Kitty to download the related content (usually the TV-program) automatically. Like a video recorder! ;)<br>If you turn off this option, you have to click on <b>Download media</b> in your <b>Video</b> menu."),welc4v);
		chk_download_on_collect=new QCheckBox(i18n("Autodownload content when added to my collection."),welc4v);
		chk_download_on_collect->setChecked(localsettings.set_download_on_collect);
		QLabel *spacer4w=new QLabel("",welc4v);
		spacer4w->setSizePolicy(QSizePolicy::Ignored,QSizePolicy::Expanding);

		welc5=new QHBox(this);
		QLabel *side5=new QLabel("",welc5);
		side5->setPixmap(sideimgw);
		side5->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		QHBox *welc5v=new QVBox(welc5);
		welc5->setSpacing(KDialog::spacingHint());
		welc5v->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("Kitty can do something when it starts...<br><br>Kitty can be minimized at startup. It is handy when you want to run Kitty after login.<br>If you turn this option off, Kitty will pop-up as the other standard applications at startup."),welc5v);
		chk_start_minimized=new QCheckBox(i18n("Start Kitty minimised on tray."),welc5v);
		chk_start_minimized->setChecked(localsettings.start_minimized);
		new QLabel(i18n("Kitty can restart your partially downloaded TV-programs at startup. It is useful when you want to complete your download at startup. Kitty will alert you when videos are downloaded.<br>If you turn off this option, you have to restart your downloads manually."),welc5v);
    		chk_restart_partial=new QCheckBox(i18n("Restart partially downloaded media at startup."),welc5v);
		chk_restart_partial->setChecked(localsettings.restart_partial);
		QLabel *spacer5w=new QLabel("",welc5v);
		spacer5w->setSizePolicy(QSizePolicy::Ignored,QSizePolicy::Expanding);

		welc7=new QHBox(this);
		QLabel *side7=new QLabel("",welc7);
		side7->setPixmap(sideimgw);
		side7->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		QHBox *welc7v=new QVBox(welc7);
		welc7->setSpacing(KDialog::spacingHint());
		welc7v->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("Kitty's Guide is a public and freely updatable channel guide designed for Kitty. It needs to be updated with new channels or existing channels description can be out-of-date.<br>You can submit your feed data to the Kitty's Guide clicking on the option <b>Add to Kitty's guide</b> from the contextual menu of the subscribed channels list.<br>But Kitty can also do it for you.<br>Turning on this option, every new channel you will add to your subscribed channels list will be automatically added to the Kitty's Guide and will be avaible to everyone using the main page or the NekoTongue tool.<br>Channel submission will make the Kitty's Guide bigger, smarter and cool for you and everyone is using Kitty.<br><br>If you turn off this option, Kitty will not update its online guide automatically... but you can do it manually."),welc7v);
		chk_autosubmit_feed=new QCheckBox(i18n("Automatically submit new subscribed feeds to the Kitty's guide."),welc7v);
		chk_autosubmit_feed->setChecked(localsettings.autosubmit_feed);
		QLabel *spacer7w=new QLabel("",welc7v);
		spacer7w->setSizePolicy(QSizePolicy::Ignored,QSizePolicy::Expanding);

		welc6=new QHBox(this);
		QLabel *sidew6=new QLabel("",welc6);
		sidew6->setPixmap(sideimgw);
		sidew6->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		welc6->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("<h2>Well done!</h2><br>This wizard finish here and Kitty is ready for you. Thank you for using (or maybe just trying) Kitty and have fun!<br><br><b>Remember!</b><br>You can run NekoTongue from the <b>Feeds</b> menu and you can setup Kitty from the <b>Configure Kitty...</b> option of the <b>Settings</b> menu."),welc6);

		addPage(welc1,i18n("Welcome to Kitty!"));
		addPage(welc2,i18n("Use the tongue, Luke."));
		addPage(page2,i18n("Your tastes here!"));
		addPage(page3,i18n("Is this tasty?"));
		addPage(welc3,i18n("Found anything?"));
		addPage(welc4,i18n("Automatic stuff."));
		addPage(welc5,i18n("Startup stuff."));
		addPage(welc7,i18n("Help Kitty!"));
		addPage(welc6,i18n("Finish!"));

		
	} else {
		/*
			Normal wizard
		*/

		setCaption(i18n("Kitty NekoTongue Wizard"));

		page1=new QHBox(this);
		QLabel *side1=new QLabel("",page1);
		side1->setPixmap(sideimg);
		side1->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
		page1->setSpacing(KDialog::spacingHint());
		new QLabel(i18n("<h2>Welcome to NekoTongue!</h2><br>Kitty's NekoTongue is a \"composed search service\" provided by the Kitty's TV Guide service. It searches for you the Kitty's TV Guide using your <i>Tasty words</i>&copy; and their priority.<br><br>Try it... and remember that cat's tongue is really sensible... ;)"),page1);

		addPage(page1,i18n("Welcome!"));
		addPage(page2,i18n("Your tastes here!"));
		addPage(page3,i18n("Is this tasty?"));
	}

	changeTastes();
}

void kitty_nekotongue::changeTastes() {
	kitty_globals::tastes=tastes->items();
	if (kitty_globals::tastes.count()==0 || kitty_globals::tastes.count()>20) {
		nextButton()->setEnabled(false);
	} else {
		nextButton()->setEnabled(true);
	}
}

kitty_nekotongue::~kitty_nekotongue()
{
}

void kitty_nekotongue::openURLRequest(const KURL &url, const KParts::URLArgs & args)
{
	if (url.queryItem("q")=="channel/subscribe/") {
			// Kitty guide (old dtv way)
			mainwindow->addurl(url.queryItem("suburl"));
	} else {
		if (args.doPost()) {
			tasteml->browserExtension()->setURLArgs(args);
		}
		tasteml->openURL( url);
	}
} 

void kitty_nekotongue::openTastyPage() {
	KURL a;
	QString str;
	int i=0;
	/* add tastes to request */
	for (QStringList::Iterator it=kitty_globals::tastes.begin();it!=kitty_globals::tastes.end();++it) {
		a.addQueryItem(str.sprintf("t_%d",i),*it);
		i++;
	}
	a.addQueryItem("action","taste");

	QCString qdata=QCString(a.query().mid(1));

	KParts::URLArgs args;	
	args.setDoPost(true);
	args.postData=qdata;
	args.setContentType("Content-Type: application/x-www-form-urlencoded");

	tasteml->browserExtension()->setURLArgs(args);

	tasteml->openURL( kitty_globals::kitty_url);
}

void kitty_nekotongue::accept() {
	localsettings.set_open_on_click=chk_open_on_click->isChecked();
	localsettings.set_download_on_collect=chk_download_on_collect->isChecked();
	localsettings.start_minimized=chk_start_minimized->isChecked();
	localsettings.restart_partial=chk_restart_partial->isChecked();	
	localsettings.autosubmit_feed=chk_autosubmit_feed->isChecked();	
	kitty_globals::settings=localsettings;
	close();
}

void kitty_nekotongue::showPage( QWidget* page )
{
	finishButton()->setEnabled(false);

	if (page==page3) {
		openTastyPage();
	}

	KWizard::showPage(page);

	if (page==page2) {
		changeTastes();
	}

	if (page==welc6) {
		finishButton()->setEnabled(true);
	}

}

#include "kitty_nekotongue.moc"
