#ifndef KP_VIEW_MODEL_H_
#define KP_VIEW_MODEL_H_

#include "../kptraininglog.h"
#include "../kputil.h"

#define KP_TYPE_VIEW_MODEL (kp_view_model_get_type())
#define KP_VIEW_MODEL(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_VIEW_MODEL, KPViewModel))
#define KP_VIEW_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_VIEW_MODEL, KPViewModelClass))
#define KP_IS_VIEW_MODEL(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_VIEW_MODEL))
#define KP_IS_VIEW_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_VIEW_MODEL))
#define KP_VIEW_MODEL_GET_CLASS(object) (G_TYPE_INSTANCE_GET_INTERFACE ((object), KP_TYPE_VIEW_MODEL, KPViewModelIface))

typedef enum {
  KP_VIEW_MODEL_TYPE_DAY      = 0,
  KP_VIEW_MODEL_TYPE_WEEK     = 1,
  KP_VIEW_MODEL_TYPE_MONTH    = 2,
  KP_VIEW_MODEL_TYPE_YEAR     = 3,
  KP_VIEW_MODEL_TYPE_ALL_TIME = 4,
  KP_VIEW_MODEL_TYPE_N        = 5,
} KPViewModelType;

typedef struct KPViewModel_      KPViewModel; /* dummy object */
typedef struct KPViewModelIface_ KPViewModelIface;

/*
 * Implemented in
 *  - KPCalendarView
 *  - KPChart
 *  - KPStatsView
 *  - KPView
 */


struct KPViewModelIface_ {
  GTypeInterface      g_iface;

  /* Signals */
  void             (* view_set)  (KPViewModel *model,
                                  KPViewModelType type);

  void             (* date_set)  (KPViewModel *model,
                                  KPDate *date);
  
  /* Virtual table */

  void             (* get_dmy)       (KPViewModel *model,
                                      guint *d,
                                      guint *m,
                                      guint *y);
                                      
  void             (* set_dmy)       (KPViewModel *model,
                                      guint d,
                                      guint m,
                                      guint y);
  
  KPViewModelType  (* get_view_type) (KPViewModel *model);
  void             (* set_view_type) (KPViewModel *model,
                                      KPViewModelType type);
  void             (* set_log)       (KPViewModel *model,
                                      KPTrainingLog *log);
  void             (* unset_log)     (KPViewModel *model);
};

/* Functions */
GType             kp_view_model_get_type        (void);
GDateYear         kp_view_model_get_year        (KPViewModel *model);
GDateMonth        kp_view_model_get_month       (KPViewModel *model);
GDateDay          kp_view_model_get_day         (KPViewModel *model);

void              kp_view_model_get_dmy         (KPViewModel *model,
                                                 guint *d,
                                                 guint *m,
                                                 guint *y);

void              kp_view_model_set_dmy         (KPViewModel *model,
                                                 guint d,
                                                 guint m,
                                                 guint y);
void              kp_view_model_set_log         (KPViewModel *model,
                                                 KPTrainingLog *log);
void              kp_view_model_unset_log       (KPViewModel *model);
KPViewModelType   kp_view_model_get_view_type   (KPViewModel *model);
void              kp_view_model_set_view_type   (KPViewModel *model,
                                                 KPViewModelType type);
gchar            *kp_view_model_get_date_format (KPViewModel *model);


#endif /* KP_VIEW_H_ */


