/* $Id: we_scripting.c 1014 2009-02-01 12:46:52Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/


/*************************
 * File global variables *
 *************************/


GtkWidget *
get_we_scripting_tab(GtkWidget *wndParent, GladeXML *gladexml)
{
  GtkWidget *panel;
  GtkWidget *txtScriptFile;
  GtkWidget *btnSelectNone;

  panel = glade_xml_get_widget(gladexml, "we_panel_scripting");

  txtScriptFile = glade_xml_get_widget(gladexml, "txtScriptFile");
  btnSelectNone = glade_xml_get_widget(gladexml, "btnSelectNone");

  g_signal_connect_swapped(G_OBJECT(btnSelectNone), "clicked",
                           G_CALLBACK(gtk_file_chooser_unselect_all),
                           txtScriptFile);

  return panel;
}


void
fill_we_scripting_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *txtScriptFile;

  if (!world) {
    return;
  }

  txtScriptFile = glade_xml_get_widget(gladexml, "txtScriptFile");
  if (world->scriptfile) {
    gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(txtScriptFile),
                                  world->scriptfile);
  }
}



void
update_we_scripting_parameters(World *world)
{
  GladeXML  *gladexml;
  GtkWidget *txtScriptFile;
  gchar     *newval;

  gladexml = glade_get_widget_tree(world->dlgEditWorld);
  txtScriptFile = glade_xml_get_widget(gladexml, "txtScriptFile");
  newval = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(txtScriptFile));
  if (!newval) {
    g_free(world->scriptfile);
    world->scriptfile = NULL;
  } else if (!world->scriptfile || strcmp(world->scriptfile, newval) != 0) {
    g_free(world->scriptfile);
    world->scriptfile = g_strdup(newval);
  }
  g_free(newval);
}
