/***************************************************************************
 *   Copyright (C) 2004, 2005 Cédric Brun                                  *
 *   cedric.brun@free.fr                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

/**
 * This work has been based on a code source of Thomas Nagy 
 * */
#ifndef _KDISSDB_H
#define _KDISSDB_H

#include <qstringlist.h>
#include <qobject.h>
#include <klibloader.h>
#include "DGenerator.h"

class kdissdocbookFactory : KLibFactory { Q_OBJECT public: QObject *createObject(QObject *, const char *, const char *, const QStringList & = QStringList()); };

class DDataItem;
/**
 *  Docbook book generator
 *
 * @short Docbook writer document generator
 * @author Cédric Brun  <cedric.brun@free.fr>
 */
class kdissdocbook : public DGenerator
{
    public:
	kdissdocbook() : DGenerator() {}
	~kdissdocbook() {}

	const QString identifikation();
	const QString fullName();
	const QString group();
	const QString description();
	const QString quickstart();

    private:
	bool writeMaindoc(DDataItem*, const QString &);
	void writeItem(DDataItem* item, QTextStream & s, int level);
	void outputData(DDataItem* item, QTextStream & s, int level);

};

#endif // _KDISSDB_H
