// -*- c++ -*-
/*
 * Copyright (C) 2002 Zsolt Rizsanyi <rizsanyi@myrealbox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#ifndef __LIRC_H__
#define __LIRC_H__

#include <qmap.h>
#include <qobject.h>
#include <qstring.h>

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_LIRC_KDETV
# include <lirc/lirc_client.h>
#endif

/**
 * Object for lirc support.
 */
class Lirc : public QObject
{
    Q_OBJECT

public:
    /**
     * Creates a lirc connection, and initializes configuration with appname @p appname.
     */
    Lirc( QObject *parent, const QString& appname);
    virtual ~Lirc();

    /**
     * Sets the default keymap to use if there is no lirc config file, or default is specified
     * as command.
     * @p keymap will be deleted in the destructor
     */
    void setDefaultKeyMap(const QMap<QString, QString>& keymap) { _keymap = keymap; }

signals:
    /**
     * an event received from lirc
     * you get this signal only if a not recognized key is pressed
     * @p key the name of the key pressed
     */
    void event(const QString& key, unsigned repeat);

    /**
     * lirc command received
     * @p cmd the cmd corresponding to pressed lirc key (as defined in the lirc config file)
     */
    void command(const QString& cmd, unsigned repeat);

private slots:
    void dataReceived();

private:
    QString _appname;
#ifdef HAVE_LIRC_KDETV
    lirc_config* _config;
    int _lircfd;
#endif
    QMap<QString, QString> _keymap;
};

#endif // __LIRC_H__
