/*
 *
 * Copyright (C) 2003 George Staikos <staikos@kde.org>
 *               2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#include "kdetvchannelplugin.h"
#include "channelstore.h"

#include <qfile.h>

#include <kdebug.h>
#include <kparts/componentfactory.h>


KdetvChannelPlugin::KdetvChannelPlugin(Kdetv *ktv, const QString& cfgkey, QObject *o, const char* n)
    : KdetvPluginBase(ktv, cfgkey, o, n),
      _flags(FormatReadWrite)
{
}


KdetvChannelPlugin::~KdetvChannelPlugin()
{
}


bool KdetvChannelPlugin::canRead(const QString& fmt) const
{
	return (_flags & FormatRead) && (_fmtName == fmt);
}


bool KdetvChannelPlugin::canWrite(const QString& fmt) const
{
	return (_flags & FormatWrite) && (_fmtName == fmt);
}


bool KdetvChannelPlugin::handlesFile(const QString& filename, int rflags) const
{
	return ((_flags & rflags) == rflags) && filename.endsWith(_fmtName);
}


bool KdetvChannelPlugin::load(ChannelStore *store, KdetvChannelPlugin::ChannelFileMetaInfo *info,
                              const QString &filename, const QString& fmt)
{  
	QFile file(filename);
	if (!file.open(IO_ReadOnly)) {
	    return false;
	}

	if (!load(store, info, &file, fmt)) {
		kdWarning() << "KdetvChannelPlugin::load(...) sub-class load method failed" << endl;
		return false;
	}

	kdDebug() << "KdetvChannelPlugin::load(...) sub-class load ok" << endl;
	return true;
}


bool KdetvChannelPlugin::save(ChannelStore *store, KdetvChannelPlugin::ChannelFileMetaInfo *info,
                              const QString &filename, const QString& fmt)
{
	QFile file(filename);
	if (!file.open(IO_WriteOnly)) {
	    return false;
	}

	if (!save(store, info, &file, fmt)) {
		kdWarning() << "KdetvChannelPlugin::save(...) sub-class save method failed" << endl;
		return false;
	}

	kdDebug() << "KdetvChannelPlugin::save(...) sub-class save ok" << endl;
	return true;
}


bool KdetvChannelPlugin::load(ChannelStore *, KdetvChannelPlugin::ChannelFileMetaInfo *,
                              QIODevice *, const QString&)
{
	return false;
}

bool KdetvChannelPlugin::save(ChannelStore *, KdetvChannelPlugin::ChannelFileMetaInfo *,
                              QIODevice *, const QString&)
{
	return false;
}


#include "kdetvchannelplugin.moc"

