/*
 * sk_effects.h
 *
 */

#ifndef SKULPTURE_EFFECTS_H
#define SKULPTURE_EFFECTS_H 1


/*-----------------------------------------------------------------------*/

#include <QtGui/QRgb>

#define F_SHIFT 11

void filterRgbPixels(QRgb *rgb, int w, int h, int stride, int f);


/*-----------------------------------------------------------------------*/

#include <QtGui/QImage>
#include <cmath>

static inline void filterImage(QImage &im, double f)
{
	filterRgbPixels((QRgb *) im.bits(), im.width(), im.height(), im.bytesPerLine() / sizeof(QRgb), int((1 << F_SHIFT) * f));
}


static inline void blurImage(QImage &im, int radius)
{
	if (radius >= 1) {
		double f = 1.0 - exp(-2.3 / (radius + 1.0));
		filterImage(im, f);
	}
}


/*-----------------------------------------------------------------------*/

#endif


