/*
 * sk_config.cpp
 *
 */

#include "sk_config.h"
#include <QtCore/QSettings>
#include <QtCore/QDir>
#include <QtCore/QUuid>
#include <QtGui/QMdiSubWindow>
#include <QtGui/QCloseEvent>
#include <QtGui/QStyleFactory>
#include <QtGui/QApplication>
#include <QtGui/QDialog>
#include <QtGui/QDesktopWidget>
#include <QtCore/QDebug>
#include <KDE/KGlobal>
#include <cstdio>


/*-----------------------------------------------------------------------*/

extern "C" KDE_EXPORT QWidget* allocate_kstyle_config(QWidget* parent)
{
	return new SkulptureStyleConfig(parent);
}


/*-----------------------------------------------------------------------*/

#include "ui_sk_preview1.h"

class Preview1Window : public QDialog, private Ui::SkulpturePreview1
{
	public:
		explicit Preview1Window(QWidget *parent = 0);

	public:
		virtual void closeEvent(QCloseEvent *e);
                QLayout *dialogLayout() const {
                    return verticalLayout_9;
                }

	private:
		void init();
};


Preview1Window::Preview1Window(QWidget *parent)
	: QDialog(parent)
{
	init();
}


void Preview1Window::closeEvent(QCloseEvent *e)
{
	e->ignore();
}


void Preview1Window::init()
{
	setWindowFlags(Qt::Widget);
	setupUi(this);
}


/*-----------------------------------------------------------------------*/

#include "ui_sk_preview2.h"

class Preview2Window : public QMainWindow, private Ui::SkulpturePreview2
{
	public:
		explicit Preview2Window(QWidget *parent = 0);

	public:
		virtual void closeEvent(QCloseEvent *e);

	private:
		void init();
};


Preview2Window::Preview2Window(QWidget *parent)
	: QMainWindow(parent)
{
	init();
}


void Preview2Window::closeEvent(QCloseEvent *e)
{
	e->ignore();
}


void Preview2Window::init()
{
	setWindowFlags(Qt::Widget);
	setupUi(this);
}


/*-----------------------------------------------------------------------*/

class KThemePreview::Private
{
	public:
		QWidget *q;
		QMdiArea *area;

	public:
		void init();
};


KThemePreview::KThemePreview(QWidget *parent)
	: QWidget(parent), d(new Private)
{
	d->q = this;
}


KThemePreview::~KThemePreview()
{
	delete d;
}


/*-----------------------------------------------------------------------*/

void SkulptureStyleConfig::subWindowActivated(QMdiSubWindow *window)
{
	if (window) {
		QWidget *parent = window->parentWidget();
		if (parent) {
			const QList<QObject *> children = parent->children();
            Q_FOREACH (QObject *child, children) {
				QWidget *widget = qobject_cast<QWidget *>(child);
				if (widget) {
					widget->setWindowTitle(QLatin1String(child == window ? "Active Window" : "Inactive Window"));
				}
			}
		}
	}
}


void SkulptureStyleConfig::updatePreview()
{
	QStyle *style = QStyleFactory::create(QLatin1String("skulpture"));
	if (style) {
		int index = style->metaObject()->indexOfMethod("skulpturePrivateMethod(SkulpturePrivateMethod,void*)");
		if (index >= 0) {
			QUuid uuid = QUuid::createUuid();
			QDir tempDir = QDir::temp();
			// ### we may add a way to avoid the file completely.
			QString fileName = QLatin1String("skulpture-temp-settings-") + uuid.toString() + QLatin1String(".ini");
			QString absFileName = tempDir.absoluteFilePath(fileName);
			{
				QSettings s(absFileName, QSettings::IniFormat);
				saveSettings(s);
				// make visible in other process
				s.sync();
			}
			SkMethodDataSetSettingsFileName data;
			data.version = 1;
			data.fileName = absFileName;

			int result;
			int id = SkulptureStyle::SPM_SetSettingsFileName;
			void *dat = &data;
			void *param[] = {&result, &id, &dat};
			style->qt_metacall(QMetaObject::InvokeMetaMethod, index, param);

			tempDir.remove(fileName);

                        int margin = style->pixelMetric(QStyle::PM_DefaultTopLevelMargin);
                        dialogLayout->setContentsMargins(margin, margin, margin, margin);
			QList<QMdiSubWindow *> windows = mdiArea->findChildren<QMdiSubWindow *>();
            Q_FOREACH (QMdiSubWindow *window, windows) {
				window->setFocusPolicy(Qt::ClickFocus);
				QList<QWidget *> widgets = window->widget()->findChildren<QWidget *>();
                Q_FOREACH (QWidget *widget, widgets) {
					// TODO: only update widgets that have changes in settings
					widget->setStyle(style);
					widget->setFocusPolicy(Qt::ClickFocus);
				}
			}
		}
	}
}


/*-----------------------------------------------------------------------*/

SkulptureStyleConfig::SkulptureStyleConfig(QWidget *parent)
	: QWidget(parent)
{
	init();
}


enum PreviewPosition
{
    PP_Auto,
    PP_Hidden,
    PP_InTab,
    PP_Left,
    PP_Top,
    PP_Right,
    PP_Bottom
};


void SkulptureStyleConfig::init()
{
	KGlobal::locale()->insertCatalog(QLatin1String("kstyle_skulpture_config"));
	setupUi(this);
        QList<QWidget *> children = tabWidget->findChildren<QWidget *>();
        Q_FOREACH (QWidget *child, children) {
            if (!(child->isEnabled())) {
                child->hide();
            }
        }
        QSize availableSize = qApp->desktop()->availableGeometry(this).size();
        QSettings s(QSettings::IniFormat, QSettings::UserScope, QLatin1String("SkulptureStyle"), QLatin1String(""));
        QString previewPositionText = s.value(QLatin1String("ConfigDialog/PreviewPosition"), QLatin1String("auto")).toString().toLower();
        PreviewPosition previewPosition = PP_Auto;
        switch (previewPositionText.at(0).unicode()) {
            case 'a':
            default:
                previewPosition = PP_Auto;
                break;
            case 'l':
                previewPosition = PP_Left;
                break;
            case 't':
                previewPosition = PP_Top;
                break;
            case 'b':
                previewPosition = PP_Bottom;
                break;
            case 'r':
                previewPosition = PP_Right;
                break;
            case 'c': // center
            case 'i':
                previewPosition = PP_InTab;
                break;
            case 'n': // none
            case 'h':
                previewPosition = PP_Hidden;
                break;
        }
        if (previewPosition == PP_Auto) {
            if (availableSize.height() < 700) {
                if (availableSize.width() < 800) {
                    previewPosition = PP_InTab;
                } else {
                    previewPosition = PP_Left;
                }
            } else {
                previewPosition = PP_Top;
            }
        }
        switch (previewPosition) {
            case PP_Left:
                mdiArea->setMinimumSize(QSize(qMin(570, availableSize.width() - 400), 290));
                vboxLayout->setDirection(QBoxLayout::LeftToRight);
                break;
            case PP_Top:
                mdiArea->setMinimumSize(QSize(570, 290));
                break;
            case PP_Right:
                mdiArea->setMinimumSize(QSize(qMin(570, availableSize.width() - 400), 290));
                vboxLayout->setDirection(QBoxLayout::RightToLeft);
                break;
            case PP_Bottom:
                mdiArea->setMinimumSize(QSize(570, 290));
                vboxLayout->setDirection(QBoxLayout::BottomToTop);
                break;
            case PP_InTab:
                tabWidget->addTab(mdiArea, QLatin1String("Preview"));
                break;
            case PP_Hidden:
                mdiArea->hide();
                break;
            case PP_Auto: // avoid warning
                break;
        }
        mdiArea->setBackground(QColor(120, 120, 150));
        tabWidget->setCurrentIndex(0);

        sbDialogMargins->setMinimum(-1);
        sbHorizontalSpacing->setMinimum(-1);
        sbLabelSpacing->setMinimum(-1);
        sbMenuBarSize->setMinimum(-1);
        sbMenuItemSize->setMinimum(-1);
        sbPushButtonSize->setMinimum(-1);
        sbScrollBarSize->setMinimum(-1);
        sbSliderSize->setMinimum(-1);
        sbToolButtonSize->setMinimum(-1);
        sbVerticalSpacing->setMinimum(-1);
        sbWidgetMargins->setMinimum(-1);
        sbWidgetSize->setMinimum(-1);
        sbTextShift->setMinimum(-9);
        sbTextShift->setMaximum(9);

        sbDialogMargins->setSuffix(QLatin1String(" pixels"));
        sbHorizontalSpacing->setSuffix(QLatin1String(" pixels"));
        sbLabelSpacing->setSuffix(QLatin1String(" pixels"));
        sbMenuBarSize->setSuffix(QLatin1String(" pixels"));
        sbMenuItemSize->setSuffix(QLatin1String(" pixels"));
        sbPushButtonSize->setSuffix(QLatin1String(" pixels"));
        sbScrollBarSize->setSuffix(QLatin1String(" pixels"));
        sbSliderSize->setSuffix(QLatin1String(" pixels"));
        sbToolButtonSize->setSuffix(QLatin1String(" pixels"));
        sbVerticalSpacing->setSuffix(QLatin1String(" pixels"));
        sbWidgetMargins->setSuffix(QLatin1String(" pixels"));
        sbWidgetSize->setSuffix(QLatin1String(" pixels"));

        sbDialogMargins->setSpecialValueText(QLatin1String("(default)"));
        sbHorizontalSpacing->setSpecialValueText(QLatin1String("(default)"));
        sbLabelSpacing->setSpecialValueText(QLatin1String("(default)"));
        sbMenuBarSize->setSpecialValueText(QLatin1String("(default)"));
        sbMenuItemSize->setSpecialValueText(QLatin1String("(default)"));
        sbPushButtonSize->setSpecialValueText(QLatin1String("(default)"));
        sbScrollBarSize->setSpecialValueText(QLatin1String("(default)"));
        sbSliderSize->setSpecialValueText(QLatin1String("(default)"));
        sbToolButtonSize->setSpecialValueText(QLatin1String("(default)"));
        sbVerticalSpacing->setSpecialValueText(QLatin1String("(default)"));
        sbWidgetMargins->setSpecialValueText(QLatin1String("(default)"));
        sbWidgetSize->setSpecialValueText(QLatin1String("(default)"));

	load();
//	KConfig wm(QLatin1String("kwinskulpturerc"), KConfig::FullConfig);
//	KConfigGroup group = wm.group("WM");
//	QColor activeBackground;
//	QString c = group.readEntry("activeBackground");
//	qDebug() << "activeBackground = " << c;
	connect(this, SIGNAL(changed(bool)), this, SLOT(updatePreview()));
	connect(mdiArea, SIGNAL(subWindowActivated(QMdiSubWindow *)), this, SLOT(subWindowActivated(QMdiSubWindow *)));

	connect(cbAnimateProgressBars, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));
	connect(cbAllowScrollBarSliderToCoverArrows, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));
	connect(cbHideShortcutUnderlines, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));
        connect(cbMakeDisabledWidgetsTransparent, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));
        connect(cbUseIconColumnForCheckIndicators, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));
        connect(cbUseSelectionColorForCheckedIndicators, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));
        connect(cbUseSelectionColorForSelectedMenuItems, SIGNAL(toggled(bool)), this, SLOT(updateChanged()));

        connect(sbDialogMargins, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbHorizontalSpacing, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbLabelSpacing, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbMenuBarSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbMenuItemSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbPushButtonSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbScrollBarSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbSliderSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbToolButtonSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbVerticalSpacing, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbWidgetMargins, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbWidgetSize, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(sbTextShift, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));

        connect(slButtonGradient, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));
        connect(slButtonRoundness, SIGNAL(valueChanged(int)), this, SLOT(updateChanged()));

        connect(lePasswordCharacters, SIGNAL(textChanged(QString)), this, SLOT(updateChanged()));
#if 1
#if 1
	QMdiSubWindow *previewwindow2 = new QMdiSubWindow(mdiArea);
//	previewwindow2->setObjectName(QLatin1String("SkulpturePreviewWindow"));
//	previewwindow2->setProperty("sk_kwin_activeBackground",
	previewwindow2->setStyle(QStyleFactory::create(QLatin1String("skulpture")));
	previewwindow2->setWidget(new Preview2Window(previewwindow2));
	previewwindow2->setGeometry(107, 7, 450, 245);
#endif
#if 1
	QMdiSubWindow *previewwindow1 = new QMdiSubWindow(mdiArea);
//	previewwindow1->setObjectName(QLatin1String("SkulpturePreviewWindow"));
	previewwindow1->setStyle(QStyleFactory::create(QLatin1String("skulpture")));
        Preview1Window *preview = new Preview1Window(previewwindow1);
	previewwindow1->setWidget(preview);
	previewwindow1->setGeometry(7, 35, 450, 245);
        dialogLayout = preview->dialogLayout();
#endif
	updatePreview();
#else
	mdiArea->hide();
#endif
}


QSize SkulptureStyleConfig::sizeHint() const
{
	return QSize(570, 0);
}


SkulptureStyleConfig::~SkulptureStyleConfig()
{
	KGlobal::locale()->removeCatalog(QLatin1String("kstyle_skulpture_config"));
}


/*-----------------------------------------------------------------------*/

void SkulptureStyleConfig::loadSettings(QSettings &s)
{
	savedAnimateProgressBars = s.value(QLatin1String("ProgressBar/AnimateProgressBars"), true).toBool();
	savedAllowScrollBarSliderToCoverArrows = s.value(QLatin1String("ScrollBar/AllowScrollBarSliderToCoverArrows"), true).toBool();
	savedHideShortcutUnderlines = s.value(QLatin1String("General/HideShortcutUnderlines"), true).toBool();
        savedMakeDisabledWidgetsTransparent = s.value(QLatin1String("General/MakeDisabledWidgetsTransparent"), true).toBool();
        savedUseIconColumnForCheckIndicators = s.value(QLatin1String("Menus/UseIconColumnForCheckIndicators"), false).toBool();
        savedUseSelectionColorForCheckedIndicators = s.value(QLatin1String("General/UseSelectionColorForCheckedIndicators"), false).toBool();
        savedUseSelectionColorForSelectedMenuItems = s.value(QLatin1String("Menus/UseSelectionColorForSelectedMenuItems"), false).toBool();

        savedDialogMargins = s.value(QLatin1String("Layout/DialogMargins"), -1).toInt();
        savedHorizontalSpacing = s.value(QLatin1String("Layout/HorizontalSpacing"), -1).toInt();
        savedLabelSpacing = s.value(QLatin1String("Layout/LabelSpacing"), -1).toInt();
        savedMenuBarSize = s.value(QLatin1String("Layout/MenuBarSize"), -1).toInt();
        savedMenuItemSize = s.value(QLatin1String("Layout/MenuItemSize"), -1).toInt();
        savedPushButtonSize = s.value(QLatin1String("Layout/PushButtonSize"), -1).toInt();
        savedScrollBarSize = s.value(QLatin1String("Layout/ScrollBarSize"), 17).toInt();
        savedSliderSize = s.value(QLatin1String("Layout/SliderSize"), 21).toInt();
        savedToolButtonSize = s.value(QLatin1String("Layout/ToolButtonSize"), -1).toInt();
        savedVerticalSpacing = s.value(QLatin1String("Layout/VerticalSpacing"), -1).toInt();
        savedWidgetMargins = s.value(QLatin1String("Layout/WidgetMargins"), -1).toInt();
        savedWidgetSize = s.value(QLatin1String("Layout/WidgetSize"), -1).toInt();
        savedTextShift = s.value(QLatin1String("General/TextShift"), 0).toInt();

        savedButtonGradient = s.value(QLatin1String("General/ButtonGradientIntensity"), 0).toInt();
        savedButtonRoundness = s.value(QLatin1String("General/ButtonRoundness"), 0).toInt();

        savedPasswordCharacters = s.value(QLatin1String("General/PasswordCharacters"), QString(QChar(ushort(10039)))).toString();
        apply();
}


void SkulptureStyleConfig::saveSettings(QSettings &s)
{
	s.setValue(QLatin1String("ProgressBar/AnimateProgressBars"), cbAnimateProgressBars->isChecked());
	s.setValue(QLatin1String("ScrollBar/AllowScrollBarSliderToCoverArrows"), cbAllowScrollBarSliderToCoverArrows->isChecked());
	s.setValue(QLatin1String("General/HideShortcutUnderlines"), cbHideShortcutUnderlines->isChecked());
        s.setValue(QLatin1String("General/MakeDisabledWidgetsTransparent"), cbMakeDisabledWidgetsTransparent->isChecked());
//        s.setValue(QLatin1String("Menus/UseIconColumnForCheckIndicators"), cbUseIconColumnForCheckIndicators->isChecked());
//        s.setValue(QLatin1String("General/UseSelectionColorForCheckedIndicators"), cbUseSelectionColorForCheckedIndicators->isChecked());
//        s.setValue(QLatin1String("Menus/UseSelectionColorForSelectedMenuItems"), cbUseSelectionColorForSelectedMenuItems->isChecked());

        s.setValue(QLatin1String("Layout/DialogMargins"), sbDialogMargins->value());
        s.setValue(QLatin1String("Layout/HorizontalSpacing"), sbHorizontalSpacing->value());
        s.setValue(QLatin1String("Layout/LabelSpacing"), sbLabelSpacing->value());
        s.setValue(QLatin1String("Layout/MenuBarSize"), sbMenuBarSize->value());
        s.setValue(QLatin1String("Layout/MenuItemSize"), sbMenuItemSize->value());
        s.setValue(QLatin1String("Layout/PushButtonSize"), sbPushButtonSize->value());
        s.setValue(QLatin1String("Layout/ScrollBarSize"), sbScrollBarSize->value());
        s.setValue(QLatin1String("Layout/SliderSize"), sbSliderSize->value());
        s.setValue(QLatin1String("Layout/ToolButtonSize"), sbToolButtonSize->value());
        s.setValue(QLatin1String("Layout/VerticalSpacing"), sbVerticalSpacing->value());
        s.setValue(QLatin1String("Layout/WidgetMargins"), sbWidgetMargins->value());
        s.setValue(QLatin1String("Layout/WidgetSize"), sbWidgetSize->value());
        s.setValue(QLatin1String("General/TextShift"), sbTextShift->value());

//        s.setValue(QLatin1String("General/ButtonGradientIntensity"), slButtonGradient->value());
//        s.setValue(QLatin1String("General/ButtonRoundness"), slButtonRoundness->value());

        s.setValue(QLatin1String("General/PasswordCharacters"), lePasswordCharacters->text());
}


void SkulptureStyleConfig::load()
{
	QSettings s(QSettings::IniFormat, QSettings::UserScope, QLatin1String("SkulptureStyle"), QLatin1String(""));
	loadSettings(s);
}


void SkulptureStyleConfig::save()
{
	QSettings s(QSettings::IniFormat, QSettings::UserScope, QLatin1String("SkulptureStyle"), QLatin1String(""));
	saveSettings(s);
}


void SkulptureStyleConfig::defaults()
{
	cbAnimateProgressBars->setChecked(true);
	cbAllowScrollBarSliderToCoverArrows->setChecked(true);
	cbHideShortcutUnderlines->setChecked(true);
        cbMakeDisabledWidgetsTransparent->setChecked(true);
        cbUseIconColumnForCheckIndicators->setChecked(false);
        cbUseSelectionColorForCheckedIndicators->setChecked(false);
        cbUseSelectionColorForSelectedMenuItems->setChecked(false);

        sbDialogMargins->setValue(-1);
        sbHorizontalSpacing->setValue(-1);
        sbLabelSpacing->setValue(-1);
        sbMenuBarSize->setValue(-1);
        sbMenuItemSize->setValue(-1);
        sbPushButtonSize->setValue(-1);
        sbScrollBarSize->setValue(17);
        sbSliderSize->setValue(21);
        sbToolButtonSize->setValue(-1);
        sbVerticalSpacing->setValue(-1);
        sbWidgetMargins->setValue(-1);
        sbWidgetSize->setValue(-1);
        sbTextShift->setValue(0);

        slButtonGradient->setValue(0);
        slButtonRoundness->setValue(0);

        lePasswordCharacters->setText(QString(QChar(ushort(10039))));
}


/*-----------------------------------------------------------------------*/

void SkulptureStyleConfig::apply()
{
	cbAnimateProgressBars->setChecked(savedAnimateProgressBars);
	cbAllowScrollBarSliderToCoverArrows->setChecked(savedAllowScrollBarSliderToCoverArrows);
	cbHideShortcutUnderlines->setChecked(savedHideShortcutUnderlines);
        cbMakeDisabledWidgetsTransparent->setChecked(savedMakeDisabledWidgetsTransparent);
        cbUseIconColumnForCheckIndicators->setChecked(savedUseIconColumnForCheckIndicators);
        cbUseSelectionColorForCheckedIndicators->setChecked(savedUseSelectionColorForCheckedIndicators);
        cbUseSelectionColorForSelectedMenuItems->setChecked(savedUseSelectionColorForSelectedMenuItems);

        sbDialogMargins->setValue(savedDialogMargins);
        sbHorizontalSpacing->setValue(savedHorizontalSpacing);
        sbLabelSpacing->setValue(savedLabelSpacing);
        sbMenuBarSize->setValue(savedMenuBarSize);
        sbMenuItemSize->setValue(savedMenuItemSize);
        sbPushButtonSize->setValue(savedPushButtonSize);
        sbScrollBarSize->setValue(savedScrollBarSize);
        sbSliderSize->setValue(savedSliderSize);
        sbToolButtonSize->setValue(savedToolButtonSize);
        sbVerticalSpacing->setValue(savedVerticalSpacing);
        sbWidgetMargins->setValue(savedWidgetMargins);
        sbWidgetSize->setValue(savedWidgetSize);
        sbTextShift->setValue(savedTextShift);

        slButtonGradient->setValue(savedButtonGradient);
        slButtonRoundness->setValue(savedButtonRoundness);

        lePasswordCharacters->setText(savedPasswordCharacters);
}


void SkulptureStyleConfig::updateChanged()
{
    if (sbTextShift->value() > 0) {
        sbTextShift->setPrefix(QLatin1String("+"));
    } else {
        sbTextShift->setPrefix(QString());
    }
	if (cbAnimateProgressBars->isChecked() == savedAnimateProgressBars
		   && cbAllowScrollBarSliderToCoverArrows->isChecked() == savedAllowScrollBarSliderToCoverArrows
		   && cbHideShortcutUnderlines->isChecked() == savedHideShortcutUnderlines
                   && cbMakeDisabledWidgetsTransparent->isChecked() == savedMakeDisabledWidgetsTransparent
                   && cbUseIconColumnForCheckIndicators->isChecked() == savedUseIconColumnForCheckIndicators
                   && cbUseSelectionColorForCheckedIndicators->isChecked() == savedUseSelectionColorForCheckedIndicators
                   && cbUseSelectionColorForSelectedMenuItems->isChecked() == savedUseSelectionColorForSelectedMenuItems

                   && sbDialogMargins->value() == savedDialogMargins
                   && sbHorizontalSpacing->value() == savedHorizontalSpacing
                   && sbLabelSpacing->value() == savedLabelSpacing
                   && sbMenuBarSize->value() == savedMenuBarSize
                   && sbMenuItemSize->value() == savedMenuItemSize
                   && sbPushButtonSize->value() == savedPushButtonSize
                   && sbScrollBarSize->value() == savedScrollBarSize
                   && sbSliderSize->value() == savedSliderSize
                   && sbToolButtonSize->value() == savedToolButtonSize
                   && sbVerticalSpacing->value() == savedVerticalSpacing
                   && sbWidgetMargins->value() == savedWidgetMargins
                   && sbWidgetSize->value() == savedWidgetSize
                   && sbTextShift->value() == savedTextShift

                   && slButtonGradient->value() == savedButtonGradient
                   && slButtonRoundness->value() == savedButtonRoundness

                   && lePasswordCharacters->text() == savedPasswordCharacters
           ) {
		Q_EMIT changed(false);
	} else {
		Q_EMIT changed(true);
	}
}


/*-----------------------------------------------------------------------*/

#include "sk_config.moc"


