/***************************************************************************
                          csvimportdlg.h  -  description
                             -------------------
    begin                : Don Aug 21 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSVIMPORTDLG_H
#define CSVIMPORTDLG_H

#include <qwidget.h>
#include <kdialogbase.h>

class CSVFile;
class EncodingCombo;
class KComboBox;
class KIntNumInput;
class KLineEdit;
class KPushButton;
class KURLRequester;
class QCheckBox;
class QFrame;
class QGroupBox;
class QTable;
class QRadioButton;

/** Import a CSV (comma separated value) file into
  * a SQL table. CSV files can be generated by almost
  * any spreadsheet application.
  * This dialog is also available as a separate application
  * KESI ( http://kesi.sf.net ).
  * This class makes importing data in KBarcode very easy
  * for the user.
  *
  * @author Dominik Seichter
  */
class CSVImportDlg : public KDialogBase  {
    Q_OBJECT
    public: 
        CSVImportDlg(QWidget *parent=0, const char *name=0);
        ~CSVImportDlg();

    private slots:
        void settingsChanged();
        void setCol();
        void updateFields();
        void updateCol( int c );
        void addWidth();
        void removeWidth();

        void enableControls();

    private:
        /**
         * Returns the current database name which can be 
         * user specified or internal to KBarcode.
         * It also enables the correct GUI items for 
         * a user specified or internal database.
         *
         * \returns the name of the current database table.
         */
        QString getDatabaseName();

        /** Get the field with from listWidth
         *  as an integer list.
         */
        QValueList<int> getFieldWidth();

        /** Create the first tab of the dialog 
         *  to set the import data.
         */
        void createPage1();

        /** Create the first tab of the dialog 
         *  to set the import settings.
         */
        void createPage2();

        /** Initialize a CSVFile with the settings
         *  from the GUI.
         */
        void initCsvFile( CSVFile* file );

    private:
        KComboBox* comboSQL;
        KComboBox* comboField;
        EncodingCombo* comboEncoding;
        KIntNumInput* spinCol;
        KPushButton* buttonSet;
        KURLRequester* requester;
        QFrame* frame;
        QTable* table;
        KLineEdit* databaseName;

        QRadioButton* radioCSVFile;
        QRadioButton* radioFixedFile;

        KLineEdit* comment;
        KLineEdit* quote;
        KLineEdit* separator;

        QGroupBox* groupCSV;
        QGroupBox* groupFixed;

        KListBox* listWidth;
        KPushButton* buttonAdd;
        KPushButton* buttonRemove;
        KIntNumInput* spinNumber;

        QCheckBox* checkLoadAll;
        KIntNumInput* spinLoadOnly;

    protected slots:
        void accept();
};

#endif
