#include "kz-xmlrpc-bookmark.h"

#include <gcutter.h>
#include "kz-test-utils.h"

void test_new (void);
void test_xmlrpc_interface_uri (void);
void test_xmlrpc_user_name (void);
void test_xmlrpc_password (void);

static KzXMLRPCBookmark *bookmark;
static KzBookmark *expected;
static const gchar target_uri[] = "http://svn.sourceforge.jp/view/kazehakase/trunk/test/fixtures/bookmarkbar.xml?view=co&root=kazehakase";

void
setup (void)
{
    bookmark =  NULL;
    expected = NULL;
}

void
teardown (void)
{
    if (bookmark)
        g_object_unref(bookmark);
    if (expected)
        g_object_unref(expected);
}

void
test_new (void)
{
    bookmark = kz_xmlrpc_bookmark_new(target_uri,
                                      "Bookmark file",
                                      "http://example.com/",
                                      "user-name",
                                      "password");
    cut_assert(bookmark);
    cut_assert_true(KZ_IS_XMLRPC_BOOKMARK(bookmark));
}

void
test_xmlrpc_interface_uri (void)
{
    cut_trace(test_new());

    cut_assert_equal_string("http://example.com/",  kz_xmlrpc_bookmark_get_interface_uri(bookmark));

    kz_xmlrpc_bookmark_set_interface_uri(bookmark, "http://example.com/1/");
    cut_assert_equal_string("http://example.com/1/",  kz_xmlrpc_bookmark_get_interface_uri(bookmark));
}

void
test_xmlrpc_user_name (void)
{
    cut_trace(test_new());

    kz_xmlrpc_bookmark_set_user_name(bookmark, "user1");
    cut_assert_equal_string("user1",  kz_xmlrpc_bookmark_get_user_name(bookmark));

    kz_xmlrpc_bookmark_set_user_name(bookmark, "user2");
    cut_assert_equal_string("user2",  kz_xmlrpc_bookmark_get_user_name(bookmark));
}

void
test_xmlrpc_password (void)
{
    cut_trace(test_new());

    kz_xmlrpc_bookmark_set_password(bookmark, "password1");
    cut_assert_equal_string("password1",  kz_xmlrpc_bookmark_get_password(bookmark));

    kz_xmlrpc_bookmark_set_password(bookmark, "password2");
    cut_assert_equal_string("password2",  kz_xmlrpc_bookmark_get_password(bookmark));
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
