/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_ENTRY_H__
#define __KZ_ENTRY_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_ENTRY		(kz_entry_get_type ())
#define KZ_ENTRY(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_ENTRY, KzEntry))
#define KZ_ENTRY_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_ENTRY, KzEntryClass))
#define KZ_IS_ENTRY(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_ENTRY))
#define KZ_IS_ENTRY_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_ENTRY))
#define KZ_ENTRY_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_ENTRY, KzEntryClass))

typedef struct _KzEntry           KzEntry;
typedef struct _KzEntryClass      KzEntryClass;

struct _KzEntry
{
    GtkEntry parent;
    gchar *background_text;

    gboolean with_arrow;
};

struct _KzEntryClass
{
    GtkEntryClass parent_class;
};

GType      kz_entry_get_type                (void) G_GNUC_CONST;
GtkWidget *kz_entry_new                     (void);

void       kz_entry_set_arrow               (KzEntry      *entry,
                                             gboolean     arrow);
void       kz_entry_set_background_text     (KzEntry      *entry,
                                             const gchar  *text);
G_CONST_RETURN gchar* kz_entry_get_background_text 
                                            (KzEntry      *entry);

G_END_DECLS

#endif /* __KZ_ENTRY_H__ */
/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
