/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-folder-menu-item.c 3675 2009-02-14 01:40:31Z ikezoe $
 */

#include "kz-bookmark-folder-menu-item.h"

#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "kazehakase.h"
#include "kz-bookmark-file.h"
#include "kz-bookmark-menu-item.h"
#include "kz-bookmark-menu.h"
#include "kz-icons.h"
#include "kz-actions.h"
#include "gtk-utils.h"
#include "utils.h"


/* object class methods */
static GObject *constructor      (GType           type,
                                  guint           n_props,
                                  GObjectConstructParam *props);

G_DEFINE_TYPE(KzBookmarkFolderMenuItem, kz_bookmark_folder_menu_item, KZ_TYPE_BOOKMARK_BASE_MENU_ITEM)

static void
kz_bookmark_folder_menu_item_class_init (KzBookmarkFolderMenuItemClass *klass)
{
	GObjectClass *gobject_class;

	gobject_class   = G_OBJECT_CLASS(klass);

	/* GObject signals */
	gobject_class->constructor  = constructor;
}


static void
kz_bookmark_folder_menu_item_init (KzBookmarkFolderMenuItem *menu)
{
}


static GObject *
constructor (GType                  type,
             guint                  n_props,
             GObjectConstructParam *props)
{
	KzBookmarkFolderMenuItem *item;
	KzBookmarkBaseMenuItem *parent;
	GObject *object;
	GtkWidget *submenu;
	GtkWidget *image;
	GtkWidget *accel_label;	
	gint bookmark_max_strnum = 0;
	const gchar *title = NULL;
	KzBookmark *bookmark;
	KzWindow *kz;
	GObjectClass *klass = G_OBJECT_CLASS(kz_bookmark_folder_menu_item_parent_class);

	object = klass->constructor(type, n_props, props);
	parent = KZ_BOOKMARK_BASE_MENU_ITEM(object);
	item = KZ_BOOKMARK_FOLDER_MENU_ITEM(object);

	bookmark = parent->bookmark;
	kz = parent->kz;
#if 1
	if (!title || !* title)
		title = kz_bookmark_get_title(bookmark);
	if (!title)
		title = "";

	KZ_CONF_GET("Global" , "bookmark_cutoff_strnum" , bookmark_max_strnum , INT);

	if(bookmark_max_strnum> 0 && (g_utf8_strlen(title , -1) > bookmark_max_strnum))
	{
		gint len = g_utf8_offset_to_pointer(title, bookmark_max_strnum) - title;
		gchar *short_title = g_alloca (len + 3 + 1);
		/* 3 for "..." , 1 for '\0' */

		g_utf8_strncpy(short_title , title , bookmark_max_strnum);
		short_title[len-3] = '.';
		short_title[len-2] = '.';
		short_title[len-1] = '.';
		short_title[len] = '\0';
		accel_label = gtk_accel_label_new(short_title);
	}
	else
		accel_label = gtk_accel_label_new(title);

	gtk_misc_set_alignment(GTK_MISC(accel_label), 0.0, 0.5);

	gtk_container_add(GTK_CONTAINER(item), accel_label);
	gtk_accel_label_set_accel_widget(GTK_ACCEL_LABEL(accel_label),
			GTK_WIDGET (item));
	gtk_widget_show(accel_label);
#endif
	image = gtk_image_new_from_stock(KZ_STOCK_FOLDER,
					 KZ_ICON_SIZE_BOOKMARK_MENU);
	gtk_widget_show(image);
	gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(item),
				      image);

	/* create submenu  */
	submenu = kz_bookmark_menu_create_submenu(bookmark, kz);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), submenu);

	return object;
}


GtkWidget *
kz_bookmark_folder_menu_item_new (KzWindow *kz, KzBookmark *bookmark)
{
	KzBookmarkFolderMenuItem *menu;

	g_return_val_if_fail(KZ_IS_WINDOW(kz), NULL);
	g_return_val_if_fail(KZ_IS_BOOKMARK(bookmark), NULL);
	g_return_val_if_fail(kz_bookmark_is_folder(bookmark), NULL);

	menu = g_object_new(KZ_TYPE_BOOKMARK_FOLDER_MENU_ITEM,
			    "kz-window", kz,
			    "bookmark",  bookmark,
			    NULL);

	return GTK_WIDGET(menu);
}

