/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef IMAGETHUMBPAGE_H
#define IMAGETHUMBPAGE_H

#include "kimagethumbpage.h"
#include "wizardpagebase.h"

/**
 * @short
 * Image/thumbnail association page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class ImageThumbPage: public KImageThumbPage, public WizardPageBase {
Q_OBJECT
public:
  ImageThumbPage(QWidget *parent = 0, const char *name = 0);
  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
    
  /**
   * Rearrange the image list (move images up/down).
   */
  void slotModifyImageList();
  
  /**
   * Rearrange the thumbnail list (move images up/down).
   */
  void slotModifyThumbList();
  
  /**
   * Synchronize selections: select the matching image/thumbnail in the other list.
   * @param index the index of the currently selected item
   */
  void slotSelectInBothList(int index);

};

#endif
