/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "antistring.h"
#include "../notify/notify.h"

#include "chat_manager.h"
#include "misc.h"
#include "debug.h"
#include "protocol.h"
#include "icons_manager.h"

//#include "message_box.h"
#include <qlistbox.h>
#include <qprocess.h>
#include <qregexp.h>
#include <qspinbox.h>
#include <qmap.h>

Antistring *antistring;

extern "C" int antistring_init()
{
	antistring = new Antistring();
	MainConfigurationWindow::registerUiFile(dataPath("kadu/modules/configuration/antistring.ui"), antistring);
	notification_manager->registerEvent("Antistring", "Antistring notifications", CallbackNotRequired);

	return 0;
}

extern "C" void antistring_close()
{
	notification_manager->unregisterEvent("Antistring");
	MainConfigurationWindow::unregisterUiFile(dataPath("kadu/modules/configuration/antistring.ui"), antistring);
	delete antistring;
	antistring = 0;
}

Antistring::Antistring()
{
	addDefaultConfiguration();
	conditionsRead();
	connect(gadu,
			SIGNAL(rawGaduReceivedMessageFilter(Protocol *, UserListElements, QCString&, QByteArray&, bool&)),
			this,
			SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));
}

Antistring::~Antistring()
{
	disconnect(gadu,
			SIGNAL(rawGaduReceivedMessageFilter(Protocol *, UserListElements, QCString&, QByteArray&, bool&)),
			this,
			SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));
	conditionsSave();
}

void Antistring::messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop)
{
	kdebugf();

	if (config_file.readBoolEntry("PowerKadu", "enable_antistring")) {
		if (points(msg) >= 3) {

			Notification *notification = new Notification("Antistring", "", senders);
			notification->setText(tr("Antistring"));
			notification->setDetails(tr("Your interlocutor send you love letter"));
			notification_manager->notify(notification);

			admonish(senders);

			if (config_file.readEntry("PowerKadu", "message stop") == "true") {
				stop = true;
			}

			if (config_file.readEntry("PowerKadu", "log message") == "true") {
				writeLog(senders, msg);
			}

			/*if (config_file.readEntry("PowerKadu", "msg_en_config") == "true") {
				msg = QCString(unicode2cp(config_file.readEntry("PowerKadu", "msg_tresc_config1"))) +
						"\n\n" + msg + "\n\n" + QCString(unicode2cp(config_file.readEntry("PowerKadu",
						"msg_tresc_config2")));
			}*/
		}
	}
	kdebugf2();
}

void Antistring::writeLog(UserListElements uin, QString msg)
{
	kdebugf();

	QFile log_file(config_file.readEntry("PowerKadu", "log file", ggPath("antistring.log")));
	if (!log_file.exists()) {
		log_file.open(IO_WriteOnly);
		QTextStream stream( &log_file );
		stream << tr("     DATA AND TIME      ::   UIN   ::    MESSAGE\n") <<
				"====================================================\n";
		log_file.close();
	}

	log_file.open(IO_WriteOnly | IO_Append);
	QTextStream stream( &log_file );
	stream << QDateTime::currentDateTime(Qt::LocalTime).toString() << " :: " << uin[0].ID("Gadu") << " :: " <<
			msg << "\n";
	log_file.close();
	kdebugf2();
}

int Antistring::points(QCString& msg)
{
	kdebugf();
	int il_p = 0;

	if (msg.length() > 600 )	{ il_p +=1; }
	for (uint i = 0; i < conditions1.keys().count(); i++) {
		if (msg.find(QRegExp(conditions1[i],true)) >= 0 ) {
			il_p += conditions[i];
		}
	}

	return il_p;
	kdebugf2();
}

void Antistring::admonish(UserListElements senders)
{
	gadu->sendMessage(senders, unicode2cp(config_file.readEntry("PowerKadu", "admonish_tresc_config")));
}

void Antistring::conditionsSave()
{
	QStringList conditions_list;
	for (uint i = 0; i < conditions.keys().count(); i++) {
		conditions_list.append(QString::number(conditions[i])+"\t"+conditions1[i]);
	}
	config_file.writeEntry("PowerKadu", "antistring conditions", conditions_list.join("\t\t"));
}

void Antistring::conditionsRead()
{
	kdebugf();
	int i=0;
	bool ok;
	QString data = config_file.readEntry("PowerKadu", "antistring conditions");
	QStringList list = QStringList::split("\t\t", data);
	if (!list.count()) {
		QFile defList(dataPath("kadu/modules/data/antistring/ant_conditions.conf"));
		if (defList.open(IO_ReadOnly)) {
			QTextStream s(&defList);
			QStringList pair;
			while (!s.atEnd())
			{
				pair = QStringList::split('\t', s.readLine());
				if (pair.count() <= 0)
					continue;
				conditions[i]  = pair[0].toInt( &ok, 10);
				conditions1[i] = pair[1];
				i++;
			}
			defList.close();
		}
		else
		{
			kdebug(QString("Can't open file: %1").arg(defList.name()));
		}
	}
	else
	{
		for (uint i = 0; i < list.count(); i++) {
			QStringList sp = QStringList::split('\t', list[i]);
			conditions[i]  = sp[0].toInt( &ok, 10);
			conditions1[i] = sp[1];
		}
	}
	kdebugf2();
}

void Antistring::updateConditionList()
{
	conditionList->clear();
	for (uint i = 0; i < conditions.keys().count(); i++) {
		conditionList->insertItem("(" + QString::number(conditions[i]) + ") " + conditions1[i]);
	}
}

void Antistring::wordSelected(int index)
{
	factor->setValue(conditions[index]);
	condition->setText(conditions1[index]);
}

void Antistring::changeCondition()
{
	int index = conditionList->currentItem();
	bool ok;
	QString Condition = condition->text();
	QString wartosc = factor->text();

	if (Condition.isEmpty())
		return;

	conditionList->changeItem("("+wartosc+") "+Condition, index);

	conditions[index]=wartosc.toInt( &ok, 10);
	conditions1[index]=Condition;

	factor->setValue(0);
	condition->setText("");
}

void Antistring::deleteCondition()
{
	int index = conditionList->currentItem();

	for (uint i = index ; i < conditions.keys().count()-1 ; i++) {
		conditions[i]=conditions[i+1];
		conditions1[i]=conditions1[i+1];
	}

	conditions1.remove(conditions.keys().count()-1);
	conditions.remove(conditions.keys().count()-1);

	updateConditionList();
}

void Antistring::addCondition()
{
	kdebugf();

	QString Condition = condition->text();
	QString wartosc = factor->text();

	if (Condition.isEmpty())
		return;

	conditionList->insertItem("(" + wartosc + ") " + Condition);

	int ilosc = conditions.keys().count();
	bool ok;
	conditions[ilosc]=wartosc.toInt(&ok, 10);
	conditions1[ilosc]=Condition;

	factor->setValue(0);
	condition->setText("");

	kdebugf2();
}

void Antistring::mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow)
{
	kdebugf();

	ConfigGroupBox *groupBox = mainConfigurationWindow->configGroupBox("Chat", "Antistring", "Conditions");

	QWidget *widget = new QWidget(groupBox->widget());
	
	QGridLayout *layout = new QGridLayout(widget);
	layout->setSpacing(5);
	layout->setMargin(5);

	conditionList = new QListBox(widget);
	layout->addMultiCellWidget(conditionList, 0, 0, 0, 1);

	condition = new QLineEdit(widget);
	layout->addWidget(new QLabel(tr("Condition"), widget), 2, 0);
	layout->addWidget(condition, 2, 1);

	factor = new QSpinBox(widget);
	factor->setMinValue(0);
	factor->setMaxValue(5);
	factor->setSpecialValueText(tr("Don't use"));
	layout->addWidget(new QLabel(tr("Factor"), widget), 3, 0);
	layout->addWidget(factor, 3, 1);

	QHBox *hbox = new QHBox(widget);
	QPushButton *addConditionButton = new QPushButton(tr("Add"), hbox);
	QPushButton *changeConditionButton = new QPushButton(tr("Change"), hbox);
	QPushButton *deleteConditionButton = new QPushButton(tr("Delete"), hbox);
	layout->addWidget(hbox, 4, 1);

	groupBox->addWidgets(0, widget);
	
	connect(conditionList, SIGNAL(highlighted(int)), this, SLOT(wordSelected(int)));
	connect(addConditionButton, SIGNAL(clicked()), this, SLOT(addCondition()));
	connect(changeConditionButton, SIGNAL(clicked()), this, SLOT(changeCondition()));
	connect(deleteConditionButton, SIGNAL(clicked()), this, SLOT(deleteCondition()));

	connect(mainConfigurationWindow->widgetById("antistring/enable_log"), SIGNAL(toggled(bool)), mainConfigurationWindow->widgetById("antistring/log_file"), SLOT(setEnabled(bool)));
	

	updateConditionList();
	kdebugf2();
}

void Antistring::configurationUpdated()
{
}

void Antistring::addDefaultConfiguration()
{
	kdebugf();

	config_file.addVariable("PowerKadu", "log file", ggPath("antistring.log"));
	config_file.addVariable("PowerKadu", "admonish_tresc_config", 
		tr("http://www.olsztyn.mm.pl/~silentman/lancuszki.htm "));

	kdebugf2();
}
