/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qtextcodec.h>

#include "sendthread.h"
#include "config_file.h"
#include "misc.h"
#include "debug.h"

SendThread::SendThread()
{
	initCurl();
	displayInfos = false;
}

SendThread::~SendThread()
{
	kdebugf();
	if(running())
	{
		kdebugm(KDEBUG_INFO, "Thread is running! Terminating!\n");
		terminate();
		wait();
	}
	cleanup();
}

void SendThread::initCurl()
{
	kdebugf();
	caBundlePath = dataPath("kadu/modules/data/miastoplusa_sms/curl-ca-bundle.crt");
	curl = curl_easy_init();
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, true);
	//curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, false);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, true);
	//curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, false);
	curl_easy_setopt(curl, CURLOPT_CAINFO, caBundlePath.data());
	curl_easy_setopt(curl, CURLOPT_AUTOREFERER, TRUE);
	curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, errorMsg);
	curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, TRUE);
	curl_easy_setopt(curl, CURLOPT_MAXREDIRS, 10);
	//curl_easy_setopt(curl, CURLOPT_PROXY, "127.0.0.1:8080");
	curl_easy_setopt(curl, CURLOPT_COOKIEFILE, "");
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, (void *)getBody);
	curl_easy_setopt(curl, CURLOPT_WRITEDATA, this);
	setErrorType(NO_ERROR);
	kdebugf2();
}

void SendThread::cleanup()
{
	kdebugf();
	curl_easy_cleanup(curl);
	kdebugf2();
}
	
bool SendThread::performGet(QString path)
{
	kdebugf();
	curl_easy_setopt(curl, CURLOPT_HTTPGET, TRUE);
	curl_easy_setopt(curl, CURLOPT_URL, path.data());
	kdebugm(KDEBUG_INFO, "GET...\n");
	body = "";
	kdebugm(KDEBUG_INFO, "In performGet: errorType = %d\n", errorType);
	if(!curl_easy_perform(curl))
	{
		kdebugm(KDEBUG_INFO, "GET success.\n");
		return true;
	}
	else
	{
		setSuccess(false);
		setErrorType(CONNECTION_ERROR);
		kdebugm(KDEBUG_INFO, "GET FAILED!\n");
		return false;
	}
}

bool SendThread::performPost(QString path, QString postData)
{
	kdebugf();
	curl_easy_setopt(curl, CURLOPT_POST, TRUE);
	curl_easy_setopt(curl, CURLOPT_POSTFIELDSIZE, postData.length());
	curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postData.data());
	kdebugm(KDEBUG_INFO, "Host...\n");
	curl_easy_setopt(curl, CURLOPT_URL, path.data());
	body = "";
	if(!curl_easy_perform(curl))
	{
		kdebugm(KDEBUG_INFO, "POST success.\n");
		return true;
	}
	else
	{
		setSuccess(false);
		setErrorType(CONNECTION_ERROR);
		kdebugm(KDEBUG_INFO, "POST FAILED!\n");
		return false;
	}
}

bool SendThread::getSentSMSesInfo()
{
	if(!performGet("http://www1.plus.pl/rozrywka_i_informacje/sms/send_sms.jsp"))
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Getting info about sent messages FAILED!\n");
		setErrorType(UNKNOWN_ERROR);
		return false;
	}
	else
	{
		kdebugm(KDEBUG_INFO, "Got info about sent messages.\n");
		QString temp;
		QString sentSMSesToOthersStr;
		QString numberSubstr;
		QRegExp info(">\\d+ pkt<");
		QTextStream s(body, IO_ReadOnly);
		bool isL = false;
		while(!s.atEnd())
		{
			temp = s.readLine();
			if (isL){
				sentSMSesToOthersStr = temp;
				break;
			}
			if(temp.contains("do innych sieci"))
				isL = true;
		}

		kdebugm(KDEBUG_INFO, "OthersGSM: %s\n",	sentSMSesToOthersStr.data());
		
		int searchIndex = info.search(sentSMSesToOthersStr);
		kdebugm(KDEBUG_INFO, "searchIndex: %d\n", searchIndex);
		temp = info.cap(0);
		kdebugm(KDEBUG_INFO, "temp: %s", temp.data());
		othersInfos = temp.mid(1, temp.length() - 2);
		kdebugm(KDEBUG_INFO, "othersInfos: %s\n", othersInfos.data());
		
		return true;
	}
}

bool SendThread::login()
{
	kdebugm(KDEBUG_INFO, "post data...\n");
	char *tmp;
	QTextCodec *codec = QTextCodec::codecForName("ISO8859-2");
	QCString cClassTmp = codec->fromUnicode(config_file.readEntry("SMS", "MiastoplusaGateway_User"));
	tmp = curl_escape(cClassTmp.data(), cClassTmp.length());
	QString userUrlEncoded = tmp;
	curl_free(tmp);
	cClassTmp = codec->fromUnicode(config_file.readEntry("SMS", "MiastoplusaGateway_Pass"));
	tmp = curl_escape(cClassTmp.data(), cClassTmp.length());
        QString passUrlEncoded = tmp;
	curl_free(tmp);
	QString postData = "login=" + userUrlEncoded + "&password=" + passUrlEncoded + "&secureLogin=on&op=login&";
	kdebugm(KDEBUG_INFO, "User: %s\nPass: %s\n", userUrlEncoded.data(), passUrlEncoded.data()); 
	if(!performPost("https://www1.plus.pl/sso/logowanie/auth", postData))
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Login FAILED!\n");
		return false;
	}
	else
	{
		kdebugm(KDEBUG_INFO, "Login posted.\n");
		return true;
	}
}

bool SendThread::postSMS()
{
	kdebugf();
	char *tmp;
	QTextCodec *codec = QTextCodec::codecForName("ISO8859-2");
	QCString cClassTmp = codec->fromUnicode(msg);
	tmp = curl_escape(cClassTmp.data(), cClassTmp.length());
	QString messageUrlEncoded = tmp;
	curl_free(tmp);
	QString targetUrlEncoded = "/rozrywka_i_informacje/sms/SendSMS2.do";
	QString confirmationType = config_file.readEntry("SMS", "ConfirmationType", "none");
	QString notifyCode = "0";
	if ( confirmationType == "www" )
		notifyCode = "10";
	else if ( confirmationType == "sms" )
		notifyCode = "30";
	QString postData =
		"prefix=48&"
		"smsType=10&"
		"sendMin=0&"
		"archiveMessage=1&"
		"flashMessage=0&"
		"phoneNumber=" + nr + "&"
		"message=" + messageUrlEncoded + "&"
		"notifyCode=" + notifyCode + "&"
		"validity=48&"
		"sendDay=-1&"
		"sendHour=0&"
		"sendMin=0&"
		"targetURL=/sms/send_sms.jsp&";
	kdebugm(KDEBUG_INFO, "Posting sms...\n");
	if(!performPost("http://www1.plus.pl/rozrywka_i_informacje/sms/SendSMS2.do", postData))
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Sending sms FAILED!\n");
		return false;
	}
	else
	{
		kdebugm(KDEBUG_INFO, "SMS sent.\n");
		return true;
	}
}

bool SendThread::logout()
{
	kdebugm(KDEBUG_INFO, "Logging out...\n");
	if(!performGet("https://www1.plus.pl/sso/logowanie/form?TAM_OP=do.logout"))
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Logging out FAILED!\n");
		return false;
	}
	else
	{
		kdebugm(KDEBUG_INFO, "Logged out.\n");
		return true;
	}
}

size_t getBody(void *buffer, size_t size, size_t nmemb, SendThread *sendThread)
{
	kdebugf();
	char *buf;
	buf = (char *)buffer;
	int bodyLen = nmemb * size;
	sendThread->body.reserve(bodyLen);
	for(int i = 0; i < bodyLen; i++)
		sendThread->body += buf[i];
	
	// ********** DEBUG **********
	/*
	QFile log("/home/patryk/miastoplusa_sms.log");
	if(log.open(IO_WriteOnly | IO_Append))
	{
		kdebugm(KDEBUG_INFO, "Opening log file success.\n");
		QTextStream s(&log);
		s << sendThread->body << flush;
		log.close();
	}
	else
	{
		kdebugm(KDEBUG_INFO, "Opening log file FAILED!\n");
		kdebugm(KDEBUG_INFO, "Because of: %s\n", log.errorString().data());
	}
	*/
	// ********** DEBUG **********
	
	
	return bodyLen;
}

void SendThread::run()
{
	kdebugf();
	sentSMSesToPlus = sentSMSesToOthers = 0;
	setFinished(false);
	setErrorType(NO_ERROR);
	setSuccess();
	
	kdebugm(KDEBUG_INFO, "First GET.\nSUCCESS = %d\n", success);
	// Pierwsze otwarcie strony zebyu odebrac sessionid
	kdebugm(KDEBUG_INFO, "First GET...\n");
	if(!performGet("https://www1.plus.pl/sso/logowanie/auth"))
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "First GET failed!\n");
		return;
	}

	kdebugm(KDEBUG_INFO, "Logging in.\nSUCCESS = %d\n", success);

	// Logowanie do bramki
	if(!login())
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Login FAILED!\n");
		return;
	}
	kdebugm(KDEBUG_INFO, "Checking login.\nSUCCESS = %d\n", success);
	if(!validLogin())
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Login FAILED! - wrong login, or password.\n");
		return;
	}
	kdebugm(KDEBUG_INFO, "Posting SMS.\nSUCCESS = %d\n", success);
	
	// Wysylanie smsa
	if(!postSMS())
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Sending SMS FAILED!\n");
		logout();
		return;
	}
	
	kdebugm(KDEBUG_INFO, "Checking if SMS was sent.\nSUCCESS = %d\n", success);
	if(!validSMSSend())
	{
		setFinished();
		kdebugm(KDEBUG_INFO, "Sending SMS FAILED!\n");
		logout();
		return;
	}
	kdebugm(KDEBUG_INFO, "Getting info of sent SMSes.\nSUCCESS = %d\n", success);
	
	// Info o wyslanych sms-ach
	if(displayInfos)
		if(!getSentSMSesInfo())
		{
			setFinished();
			kdebugm(KDEBUG_INFO, "No sent SMSes info.\n");
			logout();
		}
	else
		kdebugm(KDEBUG_INFO, "Not getting infos.\n");
	
	// Wylogowuje
	kdebugm(KDEBUG_INFO, "Logging out.\nSUCCESS = %d\n", success);
	logout();
	kdebugm(KDEBUG_INFO, "SUCCESS = %d\n", success);

	kdebugm(KDEBUG_INFO, "setting finished to TRUE.\n");
	setFinished();
	kdebugf2();
	kdebugm(KDEBUG_INFO, "Emit finished...\n");
	kdebugf2();
}

QString SendThread::getErrorMsg()
{
	kdebugm(KDEBUG_INFO, "isSuccess: %d\nerrorType: %d\n", success, errorType);
	if(isSuccess())
		return QString("");
	QString err(errorMsg);
	QString retMsg;
	//kdebugm(KDEBUG_INFO, "%s\n", errorMsg);
	if(errorType == CONNECTION_ERROR)
	{
		kdebugm(KDEBUG_INFO, "%s\n", err.data());
		if(err.contains("couldn't connect to host"))
			retMsg = tr("Problem with connection to www.miastoplusa.pl!");
		else if(err.contains("SSL certificate problem, verify that the CA cert is OK."))
			retMsg = tr("Certificate verification error!!! Someone is propabely messing up with "
					"you!!! Aborting.") + "\n" + tr("libcurl said:") + "\n" + QString(errorMsg);
		else
			retMsg = tr("Some connection error has occured!") + "\n" + tr("libcurl said:") + "\n" + 
				QString(errorMsg);
	}
	else if(getErrorType() == INVALID_LOGIN)
		retMsg = tr("Login failed! Propabely wrong login name or password. SMS was not sent.");
	else if(getErrorType() == NO_FREE_MESSAGES_TO_OTHER_NETS)
		retMsg = tr("You have no free messages to networks other than PlusGSM left.");
	else if(getErrorType() == SPAM_PROTECTION)
		retMsg = tr("Spam protection: SMS was not sent.");
	else if(getErrorType() == UNKNOWN_ERROR)
		retMsg = tr("Unknown error has occured while trying to send an SMS.");
	return retMsg;
}

QString SendThread::getInfosMsg()
{
	kdebugf();
	QString retStr = tr("SMSes to other networks left on an account: ") + othersInfos;
	kdebugm(KDEBUG_INFO, "%s\n", retStr.data());
	return retStr;
}

void SendThread::setErrorType(ErrorType err)
{
	kdebugf();
	kdebugm(KDEBUG_INFO, "errorType = %d\n", errorType);
	if(err == NO_ERROR)
		errorType = err;
	else if(errorType == NO_ERROR)
	{
		kdebugm(KDEBUG_INFO, "Changing errorType to: %d\n", err);
		errorType = err;
	}
	kdebugf2();
}

bool SendThread::validLogin()
{
	kdebugf();
	QString invalidLoginSubstr = "Nieprawidowy login lub haso.";
	QString temp;
	QTextStream s(body, IO_ReadOnly);
	bool contains = false;
	while(!s.atEnd())
	{
		temp = s.readLine();
		//kdebugm(KDEBUG_INFO, "%s\n", temp.data());
		if(temp.contains(invalidLoginSubstr))
			contains = true;
	}
				
	if(contains)
	{
		kdebugm(KDEBUG_INFO, "Login FAILED!\n");
		setErrorType(INVALID_LOGIN);
		setSuccess(false);
		return false;
	}
	kdebugm(KDEBUG_INFO, "Logged in.\n");
	return true;
}

bool SendThread::validSMSSend()
{
	kdebugf();
	QString validSubstr = "SMS przekazany do wysania.";
	QString invalidSubstr = "Limit patnych SMS-w zosta wyczerpany. Doaduj konto.";
	QString spamSubstr = "Wysanie SMS-a pod ten numer jest obecnie niemoliwe ze wzgldu na zabezpieczenia antyspamowe.";
	QString temp;
	QTextStream s(body, IO_ReadOnly);
	bool containsValid = false;
	bool containsInvalid = false;
	bool containsSpam = false;
	while(!s.atEnd())
	{
		temp = s.readLine();
		if(temp.contains(validSubstr))
		{
			kdebugm(KDEBUG_INFO, "Contains validSubstr:\n%s\n", temp.data());
			containsValid = true;
		}
		else if(temp.contains(invalidSubstr))
		{
			kdebugm(KDEBUG_INFO, "Contains invalidSubstr:\n%s\n", temp.data());
			containsInvalid = true;
		}
		else if(temp.contains(spamSubstr))
		{
			kdebugm(KDEBUG_INFO, "Contains invalidSubstr:\n%s\n", temp.data());
			containsSpam = true;
		}
	}
	
	if(containsValid)
	{
		kdebugm(KDEBUG_INFO, "SMS sent.\n");
		return true;
	}
	else if(containsInvalid)
	{
		setErrorType(NO_FREE_MESSAGES_TO_OTHER_NETS);
		kdebugm(KDEBUG_INFO, "Limit of messages to other nets reached.\n");
		setSuccess(false);
		return false;
	}
	else if(containsSpam)
	{
		setErrorType(SPAM_PROTECTION);
		kdebugm(KDEBUG_INFO, "Spam protection turn off sending SMS to that number.\n");
		setSuccess(false);
		return false;
	}
	else
	{
		setErrorType(UNKNOWN_ERROR);
		kdebugm(KDEBUG_INFO, "Unknown error occured during posting SMS!\n");
		setSuccess(false);
		return false;
	}

	// Tutaj kod nie dochodzi, ale kompilator ostrzega wiec
	return false;
}

