#ifndef MAIN_CONFIGURATION_WINDOW_H
#define MAIN_CONFIGURATION_WINDOW_H

#include <qpair.h>
#include <qvaluelist.h>

#include "configuration_window.h"

class ConfigComboBox;
class ConfigLineEdit;

class ChatMessage;
class Preview;

class QCheckBox;

class MainConfigurationWindow;

/**
	@class ConfigurationUiHandler
	@author Vogel
	@short Klasa bazowa dla klas obsugujcych okno konfiguracyjne.

	Klasa dziedziczca z tej bdzie informowana o stworzeniu nowego gwnego okna
	konfiguracyjnego co da jej moliwo podpicia si pod sygnay odpowiednich
	kontrolek i odpowiedniej reakcji na nie.
 **/
// TODO: zamiast slota zwyka metoda wirtualna?
class ConfigurationUiHandler : public virtual QObject
{
	Q_OBJECT

public slots:
	/**
		Slot wywoywany, gdy gwne okno konfiguracyjne zostanie stworzone.
	 **/
	virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow) = 0;
};

/**
	@class MainConfigurationWindow
	@author Vogel
	@short Gwne okno konfiguracyjne.
 **/
class MainConfigurationWindow : public ConfigurationWindow
{
	Q_OBJECT

	static MainConfigurationWindow *Instance;
	static QValueList<QPair<QString, ConfigurationUiHandler *> > UiFiles;

	static void instanceCreated();

	ConfigurationWindow *lookChatAdvanced;

	QCheckBox *onStartupSetLastDescription;

	ConfigComboBox *emoticonsStyleComboBox;
	ConfigComboBox *emoticonsThemeComboBox;

	ConfigComboBox *browserComboBox;
	ConfigLineEdit *browserCommandLineEdit;

	ConfigComboBox *mailComboBox;
	ConfigLineEdit *mailCommandLineEdit;

	Preview *chatPreview;
	QValueList<ChatMessage *> chatMessages;

	void setLanguages();

	void setQtThemes();
	void setToolTipClasses();

	static QString findExecutable(const QStringList &paths, const QStringList &executableNames);
	// TODO: remove append parameter
	void prepareChatPreview(Preview *preview, bool append = false);

private slots:
	void onChangeEmoticonsStyle(int index);

	void onChangeStartupStatus(int index);
	void onChangeBrowser(int index);
	void onChangeMail(int index);

	void showLookChatAdvanced();
	void lookChatAdvancedDestroyed();

	void onChatSyntaxEditorWindowCreated(SyntaxEditorWindow *syntaxEditorWindow);
	void chatSyntaxFixup(QString &syntax);
	void chatFixup(Preview *preview);

	void setIconThemes();
	void setEmoticonThemes();

public:
	static MainConfigurationWindow * instance()
	{
		if (!Instance)
		{
			Instance = new MainConfigurationWindow();
			instanceCreated();
		}

		return Instance;
	}

	/**
		Rejestracja nowego pliku *.ui (dokonywana przez moduu).
		Plik uiFile zostanie wczytany wraz z otwarciem gwnego okna konfiguracyjnego.
		Obiekt uiHandle zostanie poinformowany o stworzeniu okna i bdzie mg doda
		do niego wasne interakcje.
	 **/
	static void registerUiFile(const QString &uiFile, ConfigurationUiHandler *uiHandler);
	/**
		Wyrejestrowanie pliku *.ui i klasy obsugujcej okno konfiguracyjne.
	 **/
	static void unregisterUiFile(const QString &uiFile, ConfigurationUiHandler *uiHandler);

	MainConfigurationWindow();
	virtual ~MainConfigurationWindow();

	virtual void show();

	static QString getBrowserExecutable(int browserIndex);
	static QString getEMailExecutable(int emailIndex);

	static QString browserIndexToString(int browserIndex);
	static QString emailIndexToString(int emailIndex);

protected:
	virtual void keyPressEvent(QKeyEvent *e);
};

#endif // MAIN_CONFIGURATION_WINDOW_H
