__all__ = [
    'Todo',
    'Contact',
    'Memo',
    'Event',
    'config',
    'log',
    'addressBook',
    'memoList',
    'taskList',
    'installFile',
    'conduit',
    'getProvider',
    'setProvider',
    'gui']

try:
    import gui
except ImportError:
    pass

import ConfigParser
import struct
import operator
import string
import mx.DateTime
import pisock
import os

# hmmm... this pre-supposes the _jpilot classes at the moment.
import datebk6

from conduit import conduit

from vcard import load_vcards

# These types are loaded from here for now, later hopefully something
# not in the jpilot namespace.
import _jpilot
Todo    = _jpilot.Todo
Contact = _jpilot.Contact
Memo    = _jpilot.Memo
Event   = _jpilot.Event

# default stubs
from baseclasses import addressBook, memoList, memo32List, taskList, calendar, installFile

# parse config
config = ConfigParser.ConfigParser()
if os.getenv('HOME') is not None:
    configfilename = os.path.join(os.getenv('HOME'),".jppyrc")
    if not os.path.exists(configfilename):
        print "Creating defaults file %s" % configfilename
        f = open(configfilename,"w")
        f.write("""\
[latex]
letter_base_path = %(HOME)s/letters
letter_base_file = %(HOME)s/lettters/base.tex
letter_base_makefile = %(HOME)s/letters/Makefile

[labels]
sender = %(USER)s|Edit ~/.jppyrc Your Town|Your Postcode

[core]
editor = xemacs
pdfviewer = acroread
printercommand = lpr
""" % os.environ)
        f.close()
    if os.path.exists(configfilename):
        config.read(configfilename)


providers = ['jpilot_t3','jpilot_tx','jpilot']

def setProvider(providerName, dateBkFeatures=True):
    global addressBook, memoList, memo32List, taskList, calendar, installFile, log, \
           Todo, Contact, Memo, Event
    if providerName in ('jpilot_t3','jpilot_tx'):
        import jpilot_t3
        addressBook = jpilot_t3.addressBook
        memoList = jpilot_t3.memoList
        memo32List = jpilot_t3.memo32List        
        taskList = jpilot_t3.taskList
        calendar = jpilot_t3.calendar
        installFile = jpilot_t3.installFile
        log = _jpilot.jp_logf
        if dateBkFeatures:
            taskList._recordPromotion = datebk6.taskPromotion
            memoList._recordPromotion = datebk6.memoPromotion
            addressBook._recordPromotion = datebk6.contactPromotion
            calendar._recordPromotion = datebk6.eventPromotion
            Todo   = datebk6.Todo
            Memo   = datebk6.Memo
            Contact= datebk6.Contact
            Event  = datebk6.Event
        else:
            Todo    = _jpilot.Todo
            Contact = _jpilot.Contact
            Memo    = _jpilot.Memo
            Event   = _jpilot.Event
    elif providerName == 'jpilot':
        import jpilot
        addressBook = jpilot.addressBook
        memoList = jpilot.memoList
        memo32List = jpilot.memo32List
        taskList = jpilot.taskList
        calendar = jpilot.calendar
        installFile = jpilot.installFile
        log = _jpilot.jp_logf
        Todo    = _jpilot.Todo
        Contact = _jpilot.Address
        Memo    = _jpilot.Memo
        Event   = _jpilot.Event
        if dateBkFeatures:
            raise RuntimeError("Sorry, old-style databases with DateBk6 extensions not supported.")
    else:
        raise RuntimeError("No such provider '%s'" % providerName)

def getProvider():
    return defaultProvider

if len(providers) > 0:
    setProvider(providers[0])    

