#ifndef UI_GTK_METHOD_WINDOW_H__
#define UI_GTK_METHOD_WINDOW_H__

#include <stdio.h>

enum {
    MCLASS_COLUMN,
    MMETHOD_NAME_COLUMN,
    MSECS_COLUMN,
    MCALLS_COLUMN,
    MSUBS_COLUN,
    MTOTAL_COLUMN,
    MTOTAL_CALL_COLUMN,
    MOBJECTS_COLUMN,
    MOBJSCALL_COLUMN,
    MBYTES_COLUMN,
    MMETHOD_COLUMN,   /* pointer to the method, please keep next to last */
    MN_COLUMNS
};

/** Build the window used for tracing methods. 
 */
void setup_method_tracing ();

/** Update the data in the method tracing window.
 * @param methods all the methods in the system.
 */
void update_method_tree (hashtab* methods);

/** Dump method data to the given file. 
 */
void dump_methods (hashtab* methods, FILE* f);

/** Dispose the window used for method tracing.
 */
void quit_method_window ();

/** Get current visible rows. */
int get_method_rows ();

/** Set the number of rows to show. */
void set_method_rows (int rows);

/** If the method window is non-visible, then show it. 
 *  If the method window is visible then hide it.
 */
void toggle_method_window ();

#endif /* UI_GTK_METHOD_WINDOW_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
