#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>

#include <jmp.h>
#include <timerstack.h>
#ifdef HAVE_WIN32COMPAT_H
 #include <win32compat.h>
#endif

#include <ui_gtk.h>

static int need_lock = 0;

timerstack* timerstack_new (size_t size) {
    char buf[64];
    timerstack *ts;

    if ((ts = (timerstack *)malloc(sizeof (*ts))) == NULL)
	return NULL;

    if ((ts->times = (methodtime *)malloc(sizeof (*ts->times) * size)) == NULL) {
	timerstack_free (ts);
	return NULL;
    }

    ts->top = 0;
    ts->max = size;
    ts->last_contentation = -1;
    ts->contendtime = 0;
    ts->cpu_time = 0;
    ts->waiting = 0;
    ts->timeout = 0;

    snprintf (buf, 64, "_timerstack %p", ts);
    /* XXX Do we need to strdup this? */
    ts->monitor = jmp_create_monitor (buf);

    return ts;
}


void timerstack_free (timerstack* s) {
    if (s == NULL)
	return;

    free (s->times);
    jmp_delete_monitor (s->monitor);
    free (s);
}

int timerstacks_get_need_locks () {
    return need_lock;
}

/** Set the need to lock flag. */
void timerstacks_set_need_locks (int i) {
    need_lock = i;
}

/** Lock a given timerstack */
void timerstack_lock (timerstack *s) {
    if (need_lock)
	jmp_lock_monitor (s->monitor, MONITOR_AGENT);
}

/** Unlock a given timerstack */
void timerstack_unlock(timerstack *s) {
    if (need_lock)
	jmp_unlock_monitor (s->monitor, MONITOR_AGENT);
}

/** Expand the given stack.
 * It should be locked by the caller!
 */
void timerstack_expand (timerstack* s) {
    methodtime* ns;

    if (s == NULL)
	return;

    ns = realloc (s->times, sizeof (*s->times) * s->max * 2);
    if (ns) {
	s->times = ns;
	s->max *= 2;
    } else {
	fprintf (stderr, "timerstack_expand: failed to realloc methodtimes.\n");
    }
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
