package jfractionlab.worksheets;

import java.io.File;
import java.util.ArrayList;


public class WSGMixedNumbers extends WorkSheetGenerator {

	private ArrayList<ExerciseMixedNumbers> al_exercises;
	
	public WSGMixedNumbers(File exerciseFile, File solutionFile, int fractionmax, int factormax){
		super(lang.Messages.getString("improper_fracs"), WorkSheetGenerator.TWO_COLUMN);
		if (
				(fractionmax == 10 || fractionmax == 100) 
				&& 
				(factormax == 10 || factormax == 100)
		){
			al_exercises = new ArrayList<ExerciseMixedNumbers>();
			al_solutionLine = new ArrayList<String>();
			mkExercises(nb_of_exercises,fractionmax, factormax);
			generateText();
			writeFile(
					exerciseFile,
					al_exercisesText,
					true
			);
			writeFile(
					solutionFile,
					al_solutionsText,
					false
			);
		}else{
			throw new IllegalArgumentException( "fullnumbermax and fractionmax have to be 10 or 100" );
		}
	}

	protected void mkExercises(int nb, int fractionmax, int factormax) {
		for (int i = 0; i<nb; i++){
			al_exercises.add(new ExerciseMixedNumbers(fractionmax, factormax));
		}//for
	}
	
	@Override
	protected String writeOneLine(boolean isExercise, int nb) {
		String strReturn = "";
		int fn1 = al_exercises.get(nb).getFullNumber();
		n1 = al_exercises.get(nb).getN1();
		d1 = al_exercises.get(nb).getD1();
		int fn2 = al_exercises.get(nb+1).getFullNumber();
		n2 = al_exercises.get(nb+1).getN1();
		d2 = al_exercises.get(nb+1).getD1();
			strReturn += String.valueOf(nb+1);
			strReturn += "&"; //------------------------
			strReturn += fn1+"$\\frac{"+n1+"}{"+d1+"}$ = ";
			if(!isExercise){
				strReturn += "$\\frac{"+fn1+"\\cdot"+d1+"+"+n1+"}{"+d1+"}$ = ";
				strReturn += "$\\frac{"+(fn1*d1+n1)+"}{"+d1+"}$";
			}
			if(isExercise)al_solutionLine.add("$\\frac{"+(fn1*d1+n1)+"}{"+d1+"}$");
			strReturn += "&"; //------------------------
			strReturn += String.valueOf(nb+2);
			strReturn += "&"; //------------------------
			strReturn += fn2+"$\\frac{"+n2+"}{"+d2+"}$ = ";
			if(!isExercise){
				strReturn += "$\\frac{"+fn2+"\\cdot"+d2+"+"+n2+"}{"+d2+"}$ = ";
				strReturn += "$\\frac{"+(fn2*d2+n2)+"}{"+d2+"}$";
			}
			if(isExercise)al_solutionLine.add("$\\frac{"+(fn1*d1+n1)+"}{"+d1+"}$");
			strReturn += "\\\\";
		return strReturn;
	}	
}
