/*
 * File    : RollPanel.java
 * Created : 10-mar-2004 09:50
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.beans;

/**
 *
 * @author Francesc Busquets (fbusquets@xtec.net)
 * @version 1.0
 */
public class RollPanel extends javax.swing.JPanel {
    
    /** Creates new form RollPanel */
    public RollPanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        mainPanel = new javax.swing.JPanel();
        titleBarPanel = new javax.swing.JPanel();
        rollBtn = new javax.swing.JToggleButton();
        titleLb = new javax.swing.JLabel();
        separator = new javax.swing.JSeparator();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.EtchedBorder());
        add(mainPanel, java.awt.BorderLayout.CENTER);

        titleBarPanel.setLayout(new java.awt.BorderLayout());

        titleBarPanel.setBackground(edu.xtec.util.LFUtil.getColor("TableHeader.background",  getBackground()));
        rollBtn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/panel_opened.gif")));
        rollBtn.setBorder(null);
        rollBtn.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/panel_closed.gif")));
        rollBtn.setFocusPainted(false);
        rollBtn.setContentAreaFilled(false);
        rollBtn.setBorderPainted(false);
        rollBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rollBtnActionPerformed(evt);
            }
        });

        titleBarPanel.add(rollBtn, java.awt.BorderLayout.WEST);

        titleLb.setText("title");
        titleLb.setForeground(edu.xtec.util.LFUtil.getColor("TableHeader.foreground",  getForeground()));
        titleLb.setFont(edu.xtec.util.LFUtil.getFont("TableHeader.font",  getFont()));
        titleBarPanel.add(titleLb, java.awt.BorderLayout.CENTER);

        titleBarPanel.add(separator, java.awt.BorderLayout.SOUTH);

        add(titleBarPanel, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void rollBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rollBtnActionPerformed

        mainPanel.setVisible(!rollBtn.isSelected());
        separator.setVisible(!rollBtn.isSelected());
        
    }//GEN-LAST:event_rollBtnActionPerformed

    /** Getter for property mainPanel.
     * @return Value of property mainPanel.
     *
     */
    public javax.swing.JPanel getMainPanel() {
        return mainPanel;
    }    
    
    public void setTitle(String title){
        titleLb.setText(title);        
    }
    
    public String getTitle(){
        return titleLb.getText();
    }
    
    public void setIcon(javax.swing.Icon icon){
        titleLb.setIcon(icon);
    }
    
    public javax.swing.Icon getIcon(){
        return titleLb.getIcon();
    }
    
    public boolean isOpened(){
        return !rollBtn.isSelected();
    }
    
    public void setOpened(boolean value){
        rollBtn.setSelected(!value);
        rollBtnActionPerformed(null);
    }
            
    public void setToolTipText(String text){
        super.setToolTipText(text);
        mainPanel.setToolTipText(text);
        titleBarPanel.setToolTipText(text);
        titleLb.setToolTipText(text);
    }    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel mainPanel;
    private javax.swing.JToggleButton rollBtn;
    private javax.swing.JSeparator separator;
    private javax.swing.JPanel titleBarPanel;
    private javax.swing.JLabel titleLb;
    // End of variables declaration//GEN-END:variables
    
}
