/*
 * File    : AuthorSettingsDlg.java
 * Created : 20-jun-2002 13:23
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic;

import edu.xtec.jclic.project.LibraryManager;
import edu.xtec.util.Messages;
import java.util.HashMap;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;

/**
 *
 * @author  Francesc Busquets (fbusquets@xtec.net)
 * @version 1.0
 */
public class AuthorSettingsDlg extends edu.xtec.util.ExtendedJDialog {

    AuthorSettings settings;
    public boolean result;
    java.awt.Component parent;
    Messages msg;
    
    /** Creates new form SettingsDlg */
    public AuthorSettingsDlg(AuthorSettings settings, java.awt.Component parent) {
        super(parent, "", true);
        this.parent=parent;
        this.settings=settings;
        msg=settings.rb.getOptions().getMessages();
        setTitle(msg.get("settings_title"));
        result=false;
        initComponents();
        centerOver(parent);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.JLabel browserLb;
        javax.swing.JPanel btPanel;
        javax.swing.JButton cancelButton;
        javax.swing.JLabel codebaseLb;
        javax.swing.JLabel colorLb;
        javax.swing.JPanel generalPane;
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel heightLb;
        javax.swing.JPanel htmlPane;
        javax.swing.JLabel langLb;
        javax.swing.JLabel lookLb;
        javax.swing.JTabbedPane mainPane;
        javax.swing.ButtonGroup mediaGroup;
        javax.swing.JPanel mediaPane;
        javax.swing.JPanel mediaSystemPanel;
        javax.swing.JButton okButton;
        javax.swing.ButtonGroup reportGroup;
        javax.swing.JLabel widthLb;

        reportGroup = new javax.swing.ButtonGroup();
        mediaGroup = new javax.swing.ButtonGroup();
        mainPane = new javax.swing.JTabbedPane();
        generalPane = new javax.swing.JPanel();
        lookLb = new javax.swing.JLabel();
        lookCombo = new javax.swing.JComboBox(edu.xtec.util.LFUtil.VALUES);
        langLb = new javax.swing.JLabel();
        langCombo = new javax.swing.JComboBox(Messages.getDescriptiveLanguageCodes(msg.getLocale()));
        countryLb = new javax.swing.JLabel();
        countryField = new javax.swing.JTextField();
        variantLb = new javax.swing.JLabel();
        variantField = new javax.swing.JTextField();
        browserLb = new javax.swing.JLabel();
        browserField = new javax.swing.JTextField();
        mediaPane = new javax.swing.JPanel();
        mediaSystemPanel = new javax.swing.JPanel();
        mDefaultBtn = new javax.swing.JRadioButton();
        mJMFbtn = new javax.swing.JRadioButton();
        mQTbtn = new javax.swing.JRadioButton();
        htmlPane = new javax.swing.JPanel();
        codebaseLb = new javax.swing.JLabel();
        codebaseTxt = new javax.swing.JTextField();
        colorLb = new javax.swing.JLabel();
        colorButton = new edu.xtec.jclic.beans.ColorButton();
        colorButton.setOptions(settings.rb.getOptions());
        widthLb = new javax.swing.JLabel();
        widthText = new javax.swing.JTextField();
        heightLb = new javax.swing.JLabel();
        heightText = new javax.swing.JTextField();
        btPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mainPane.setToolTipText(msg.get("settings_report_tooltip"));
        mainPane.setPreferredSize(new java.awt.Dimension(500, 400));
        generalPane.setLayout(new java.awt.GridBagLayout());

        generalPane.setToolTipText(msg.get("settings_general_tooltip"));
        lookLb.setLabelFor(lookCombo);
        lookLb.setText(msg.get("settings_look"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        generalPane.add(lookLb, gridBagConstraints);

        lookCombo.setSelectedItem(settings.lookAndFeel);
        lookCombo.setToolTipText(msg.get("settings_look_tooltip"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        generalPane.add(lookCombo, gridBagConstraints);

        langLb.setLabelFor(langCombo);
        langLb.setText(msg.get("settings_language"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        generalPane.add(langLb, gridBagConstraints);

        langCombo.setSelectedItem(Messages.getDescriptiveLanguageCode(settings.language));
        langCombo.setToolTipText(msg.get("settings_language_tooltip"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        generalPane.add(langCombo, gridBagConstraints);

        countryLb.setLabelFor(countryField);
        countryLb.setText(msg.get("settings_country"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        generalPane.add(countryLb, gridBagConstraints);

        countryField.setText(settings.country);
        countryField.setToolTipText(msg.get("settings_country_tooltip"));
        countryField.setMinimumSize(new java.awt.Dimension(75, 21));
        countryField.setPreferredSize(new java.awt.Dimension(200, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        generalPane.add(countryField, gridBagConstraints);

        variantLb.setLabelFor(variantField);
        variantLb.setText(msg.get("settings_variant"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        generalPane.add(variantLb, gridBagConstraints);

        variantField.setText(settings.variant);
        variantField.setToolTipText(msg.get("settings_variant_tooltip"));
        variantField.setMinimumSize(new java.awt.Dimension(75, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        generalPane.add(variantField, gridBagConstraints);

        browserLb.setText(msg.get("settings_browser"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        generalPane.add(browserLb, gridBagConstraints);

        browserField.setText(settings.preferredBrowser);
        browserField.setToolTipText(msg.get("settings_browser_tooltip"));
        browserField.setMinimumSize(new java.awt.Dimension(75, 21));
        browserField.setPreferredSize(new java.awt.Dimension(200, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        generalPane.add(browserField, gridBagConstraints);

        mainPane.addTab(msg.get("settings_general"), new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/settings.gif")), generalPane, "");

        mediaPane.setLayout(new java.awt.GridBagLayout());

        mediaPane.setToolTipText(msg.get("settings_media_tooltip"));
        mediaSystemPanel.setLayout(new java.awt.GridBagLayout());

        mediaSystemPanel.setBorder(new javax.swing.border.TitledBorder(msg.get("settings_media_system")));
        mDefaultBtn.setSelected(edu.xtec.jclic.Constants.DEFAULT.equals(settings.mediaSystem));
        mDefaultBtn.setText(msg.get("settings_media_default"));
        mediaGroup.add(mDefaultBtn);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        mediaSystemPanel.add(mDefaultBtn, gridBagConstraints);

        mJMFbtn.setSelected(edu.xtec.jclic.Constants.JMF.equals(settings.mediaSystem));
        mJMFbtn.setText(msg.get("settings_media_jmf"));
        mediaGroup.add(mJMFbtn);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        mediaSystemPanel.add(mJMFbtn, gridBagConstraints);

        mQTbtn.setSelected(edu.xtec.jclic.Constants.QT.equals(settings.mediaSystem));
        mQTbtn.setText(msg.get("settings_media_qt"));
        mediaGroup.add(mQTbtn);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        mediaSystemPanel.add(mQTbtn, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mediaPane.add(mediaSystemPanel, gridBagConstraints);

        mainPane.addTab(msg.get("settings_media"), new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/audio_on.gif")), mediaPane, "");

        htmlPane.setLayout(new java.awt.GridBagLayout());

        htmlPane.setToolTipText(msg.get("settings_applet_tooltip"));
        codebaseLb.setLabelFor(codebaseTxt);
        codebaseLb.setText(msg.get("applet_codebase"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(codebaseLb, gridBagConstraints);

        codebaseTxt.setToolTipText(msg.get("applet_codebase_tooltip"));
        codebaseTxt.setText(settings.appletCodeBase);
        codebaseTxt.setPreferredSize(new java.awt.Dimension(250, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(codebaseTxt, gridBagConstraints);

        colorLb.setLabelFor(colorButton);
        colorLb.setText(msg.get("applet_bgcolor"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(colorLb, gridBagConstraints);

        colorButton.setToolTipText(msg.get("applet_bgcolor_tooltip"));
        colorButton.setColor(settings.appletBgColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(colorButton, gridBagConstraints);

        widthLb.setLabelFor(widthText);
        widthLb.setText(msg.get("WIDTH"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(widthLb, gridBagConstraints);

        widthText.setToolTipText(msg.get("applet_width_tooltip"));
        widthText.setText(settings.appletWidth);
        widthText.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        widthText.setPreferredSize(new java.awt.Dimension(50, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(widthText, gridBagConstraints);

        heightLb.setLabelFor(heightText);
        heightLb.setText(msg.get("HEIGHT"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(heightLb, gridBagConstraints);

        heightText.setToolTipText(msg.get("applet_height_tooltip"));
        heightText.setText(settings.appletHeight);
        heightText.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        heightText.setPreferredSize(new java.awt.Dimension(50, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        htmlPane.add(heightText, gridBagConstraints);

        mainPane.addTab(msg.get("settings_applet"), new javax.swing.ImageIcon(getClass().getResource("/edu/xtec/resources/icons/html_doc.gif")), htmlPane);

        getContentPane().add(mainPane, java.awt.BorderLayout.CENTER);

        okButton.setText(msg.get("OK"));
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        btPanel.add(okButton);

        cancelButton.setText(msg.get("CANCEL"));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        btPanel.add(cancelButton);

        getContentPane().add(btPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed

        result=false;
        closeDialog(null);
        
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed

        if(accept()){
            result=true;
            closeDialog(null);
        }
                
        // Add your handling code here:
    }//GEN-LAST:event_okButtonActionPerformed

    public boolean accept(){
        String p1=null;
        
        settings.lookAndFeel=(String)lookCombo.getSelectedItem();
        settings.preferredBrowser=browserField.getText();
        settings.language=Messages.getLanguageFromDescriptive((String)langCombo.getSelectedItem());
        settings.country=StrUtils.nullableString(countryField.getText());
        settings.variant=StrUtils.nullableString(variantField.getText());               
        
        if(mJMFbtn.isSelected())
            settings.mediaSystem=edu.xtec.jclic.Constants.JMF;
        else if(mQTbtn.isSelected())
            settings.mediaSystem=edu.xtec.jclic.Constants.QT;
        else
            settings.mediaSystem=edu.xtec.jclic.Constants.DEFAULT;
        
        settings.appletCodeBase=StrUtils.secureString(codebaseTxt.getText(), AuthorSettings.DEFAULT_APPLET_CODEBASE);
        settings.appletWidth=StrUtils.secureString(widthText.getText(), AuthorSettings.DEFAULT_APPLET_WIDTH);
        settings.appletHeight=StrUtils.secureString(heightText.getText(), AuthorSettings.DEFAULT_APPLET_HEIGHT);
        settings.appletBgColor=colorButton.getColor();
        
        return true;
    }        
        
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField browserField;
    private javax.swing.JTextField codebaseTxt;
    private edu.xtec.jclic.beans.ColorButton colorButton;
    private javax.swing.JTextField countryField;
    private javax.swing.JLabel countryLb;
    private javax.swing.JTextField heightText;
    private javax.swing.JComboBox langCombo;
    private javax.swing.JComboBox lookCombo;
    private javax.swing.JRadioButton mDefaultBtn;
    private javax.swing.JRadioButton mJMFbtn;
    private javax.swing.JRadioButton mQTbtn;
    private javax.swing.JTextField variantField;
    private javax.swing.JLabel variantLb;
    private javax.swing.JTextField widthText;
    // End of variables declaration//GEN-END:variables

}
