/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2008 Olivier Guilyardi <olivier {at} samalyse {dot} com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   SVN:$Id: util.c 121 2008-01-10 00:17:40Z olivier $
 */


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "sequence.h"
#include "util.h"


char *
util_resampler_type_to_str (int type)
{
  static char str[64];
  switch (type) {
    case SEQUENCE_SINC   : strcpy (str, "sinc"); break;
    case SEQUENCE_LINEAR : strcpy (str, "linear"); break;
    default: sprintf (str, "UNKNOWN:%d", type);
  }
  return str;
}

int
util_str_to_resampler_type (char *str)
{
  if (strcmp (str, "sinc") == 0)    return SEQUENCE_SINC;
  if (strcmp (str, "linear") == 0)  return SEQUENCE_LINEAR;
  return -1;
}

char *
util_get_wd()
{
  char s = 16;
  char *wd = malloc (s);
  while (getcwd (wd, s) == NULL)
   {
    s += 16;
    wd = realloc (wd, s);
   }
  return wd;
}
