/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2008 Olivier Guilyardi <olivier {at} samalyse {dot} com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   SVN:$Id: arg.c 121 2008-01-10 00:17:40Z olivier $
*/

/*
 *   This file was first generated by genparse, then customized
 *   See http://genparse.sourceforge.net/
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include "config.h"
#include "arg.h"
#include "util.h"

/* Print out usage information, then exit */
void arg_usage(char * executable)
{
  printf("Usage: %s [ -phv ] <file>\n", executable);
  printf("  -p, --portprefix=STRING   JACK port name prefix (default=jackbeat)\n");
  printf("  -h, --help                Display help information\n");
  printf("  -v, --version             Output version\n");
}


/* Parse the argv array into the command line structure */
arg_t *arg_parse (int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  int c;
  arg_t *arg;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"portprefix", 1, 0, 'p'},
    {"help", 0, 0, 'h'},
    {"version", 0, 0, 'v'},
    {0, 0, 0, 0}
  };

  arg = (arg_t *) malloc (sizeof(arg_t));

  arg->argc = argc;
  arg->argv = malloc (sizeof(argv));
  for (c=0; c < argc; c++) arg->argv[c] = strdup (argv[c]);

  
  arg->port_prefix = strdup("jackbeat");
  arg->filename = NULL;

  while ((c = getopt_long(argc, argv, "p:hv", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'p': 
          free (arg->port_prefix);
          arg->port_prefix = strdup(optarg);
          break;

        case 'h': 
          arg_usage(argv[0]);
          exit(0);
          break;

        case 'v': 
          printf ("%s\n", VERSION);
          exit(0);
          break;

        default:
          arg_usage(argv[0]);
          exit(0);

        }
    } /* while */

  if (errflg)
   {
    arg_usage(argv[0]);
    exit(1);
   }

  if (optind < argc) 
   {
    if (argv[optind][0] == '/') arg->filename = strdup (argv[optind]);
    else 
     {
      char *wd = util_get_wd();
      arg->filename = malloc (strlen(wd) + strlen (argv[optind]) + 2);
      sprintf (arg->filename, "%s/%s", wd, argv[optind]);
      free (wd);
     }
    
   }

  return arg;
}
