#!/bin/sh
set -e
export GZIP="-9 -n"
export TAR_OPTIONS="--owner root --group root --mode a+rX"
pwd=`pwd`
version="$1"
if [ -z "$version" ]
then
    printf 'Usage: %s <version>\n' "$0"
    exit 1
fi
cd "`dirname "$0"`/../"
tmpdir=`mktemp -d get-orig-source.XXXXXX`
cd "$tmpdir"
hg clone -r "ocropus-$version" https://iulib.googlecode.com/hg/ "iulib-$version.orig"
rm -Rf iulib-*.orig/.hg*
tar -czf "$pwd/iulib_$version+ds.orig.tar.gz" iulib-*.orig/
cd ..
rm -Rf "$tmpdir"
