# -*- coding: iso-8859-1 -*-
""" HTML Album module

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: HTMLAlbum.py,v 1.35 2004/09/12 00:15:47 niederberger Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
import os.path,shutil,sys,traceback,time,os,random
from string import *
try:
    from qt import *
except:
    traceback.print_exc()
    print "Error importing the necessary modules."

class HTMLAlbum:
    """Handles all html output. Reads parameters from Album Wizard dlg.
    """
    def __init__(self,WizDlg):
        self.wiz = WizDlg                 # wizard dialog to extract parameters from
        self.curdb = self.wiz.env.curdb
        self.env = self.wiz.env
        self.styleflist = {"Acqua": [
                       'style.css',
                       'bg.png',
                       'coininfd.png',
                       'coininfg.png',
                       'coinsupd.png',
                       'coinsupg.png',
                       'd.png',
                       'fond.png',
                       'g.png',
                       'inf.png',
                       'space15.png',
                       'uparrow.png',
                       'left.png',
                       'right.png',
                       'sup.png'],

                         "Slides": [
                       'style.css',
                       'bg.png',
                       'coininfd.png',
                       'coininfg.png',
                       'coinsupd.png',
                       'coinsupg.png',
                       'd.png',
                       'fond.png',
                       'g.png',
                       'inf.png',
                       'space15.png',
                       'uparrow.png',
                       'left.png',
                       'right.png',
                       'sup.png']
                         }
        self.stylename = "Acqua"          # failsafe style
        self.destdir = None               # path to place root index.htm or all files if not using the inplace mode
        self.symmode = 0                  # if should place everything on destdir and make symlinks to this dir

    def start(self):
        """Called by Wizard dialog
        """
        self.symmode = self.wiz.symlinkradio.isChecked()
        self.leafpage = self.wiz.leafpagecheck.isChecked()
        self.destdir = os.path.expanduser(str(self.wiz.destdirEdit.text()))
        if not os.path.exists(self.destdir): # dir not found
            res = QMessageBox.information( self.wiz, "imgSeek","The supplied directory (%s) does not exist. Do you want me to create it ?" % self.destdir,   QString("&Create and continue"), QString("Cancel"))
            if res: return
            try:
                os.mkdir(self.destdir)
            except:
                traceback.print_exc()
                print "Unable to create directory for new album: "+ self.destdir
                return
        if not os.path.isdir(self.destdir):
            return "Album destination is not a directory."
        if self.destdir[-1] != os.sep: self.destdir = self.destdir+os.sep
        self.stylename = str(self.wiz.themecomboBox.currentText())
        pagename = self.destdir+"index.htm"
        self.serverroot = str(self.wiz.serverRootEdit.text())
        if len(self.serverroot) and self.serverroot[-1] != os.sep:
            self.serverroot = self.serverroot+os.sep
            print "fixed serverroot (appended \"/\")", self.serverroot
        pagenamew = self.serverroot+"index.htm"
        self.indexfile = open(pagename,"w")
        self.header(self.indexfile)
        self.section(self.indexfile,str(self.wiz.titleEdit.text()))
        orphanImgs = []                   # images that belong to this root page (will happen when the root page is a db dir for example)
        for it in self.curdb.batches[self.wiz.curBatch][1]:
            txt = ""
            if it[0]=="SysDir":         #add sys dir
                path = it[1]
                htname = self.pagePath(path, self.textParentFolder(pagenamew))
                self.framebig(self.indexfile,"<a href=\""+htname+"\">"+path+"</a>")
            if it[0]=="File" or it[0]=="Img":           #orphan img
                orphanImgs.append(it[1])
            if it[0]=="Dir":            #add dir
                txt = txt+"Images: %d<br>" % len(self.curdb.dirs[it[1]][3])
                txt = txt+"Subfolders: %d<br>" % len(self.curdb.dirs[it[1]][2])
                path = it[1]
                htname = self.pageDir(path,self.textParentFolder(pagenamew))
                self.framebig(self.indexfile,"<a href=\""+htname+"\">"+self.curdb.dirs[path][0]+"</a>",txt)
            if it[0]=="Group":
                txt = "%s<br>" % self.curdb.groups[it[1]][1]
                txt = txt+"Images: %d<br>" % len(self.curdb.groups[it[1]][3])
                txt = txt+"Subgroups: %d<br>" % len(self.curdb.groups[it[1]][4])
                path = it[1]
                htname = self.pageGroup(path,self.textParentFolder(pagenamew))
                self.framebig(self.indexfile,"<a href=\""+htname+"\">"+self.curdb.groups[path][0]+"</a>",txt)
            if it[0]=="Volume":
                txt = "%s<br>" % self.curdb.volumes[it[1]][2]
                txt = txt+"Directories: %d<br>" % len(self.curdb.volumes[it[1]][0])
                path = it[1]
                htname = self.pageVolume(path,self.textParentFolder(pagenamew))
                self.framebig(self.indexfile,"<a href=\""+htname+"\">"+self.curdb.volumes[path][3]+"</a>",txt)
            if it[0]=="SimGroup": #add simgroup
                txt = "Similar image(s): %d" % len(self.curdb.simgroups[it[1]][2])
                path = it[1]
                htname = self.pageSimGroup(path,self.textParentFolder(pagenamew))
                #save thumbnail to a picture representing this simgroup
                filen = os.path.split(self.curdb.img[self.curdb.simgroups[it[1]][1]][0])[-1]
                nfilen = self.curdb.img[self.curdb.simgroups[it[1]][1]][0]         # if on inplace mode, this will be replaced by a hased filename, which will be a copy of the respective image
                filenhs = self.curdb.uniqname(nfilen,".png")
                pagepath = self.destdir
                if not os.path.exists(pagepath+filenhs):
                    try:
                        self.curdb.getThumbDB(self.curdb.simgroups[it[1]][1]).save(pagepath+filenhs,"PNG")
                    except:
                        traceback.print_exc()
                        print "Unable to save thumbnail for "+ nfilen
                self.framebig(self.indexfile,"<a href=\""+htname+"\">"+self.getframetext("<img border = 0 src=\""+filenhs+"\">")+"</a>",txt)
        if orphanImgs:                  # has orphan images to show
            self.showImgList(self.indexfile,orphanImgs,self.destdir)
        self.footer(self.indexfile)
        self.indexfile.close()
        self.cpStyle(self.destdir)
        return "Album generated."

    def cpStyle(self,path):
        # copy current style files to dir path
        #basestyledir = self.env.imgseekdatadir+"styles/"+self.stylename+"/"
        basestyledir = os.path.join(self.env.imgseekdatadir,"styles",self.stylename,"")
        try:
            for fil in self.styleflist[self.stylename]:
                shutil.copyfile(basestyledir+fil,path+fil)
        except:
            traceback.print_exc()
            print "Error copying style files to destination directory."

    def showImgList(self,f,imagelist,pagepath):
        imglist = [] # is a list of lists like this: [href,imgsrc,thumbsrc,caption]

        imagelist2 = []                 # this will be populated with (filename, id) tuples and then sorted and then iterated
        # some images on imagelist are just ids: translate those to full paths, and reconstruct imagelist2
        for i in range(len(imagelist)):
            if type(imagelist[i])==int:
                imgid = imagelist[i]
                imagelist2.append((self.curdb.img[imgid][0],imgid))
            else:
                imagelist2.append((imagelist[i], -1))
                
        # sort imagelist before displaying
        def srt_fname(x,y):
            if x[0]>y[0]:
                return 1
            else:
                return -1
        
        imagelist2.sort(srt_fname)
                
        for i in range(len(imagelist2)):
            #save thumbnail
            imgid = imagelist2[i][1]
            filen = os.path.split(imagelist2[i][0])[-1] # filen = filename (NO path)
            nfilen = imagelist2[i][0]       # nfilen = full filename (WITH path) -- if on inplace mode, this will be replaced by a hashed filename, which will be a copy of the respective image.
            filenhs = self.curdb.uniquename(nfilen,".png")
            if not os.path.exists(pagepath+filenhs):
                try:
                    if imgid != -1:
                        self.curdb.getThumbDB(imgid).save(pagepath+filenhs,"PNG")
                    else:
                        self.curdb.getThumb(nfilen).save(pagepath+filenhs,"PNG")
                except:
                    print "Unable to save thumbnail for " + filen
            if self.symmode:
                filen = self.curdb.uniquename(nfilen, self.curdb.extension(nfilen))
                if not os.path.exists(pagepath+filen):
                    if self.wiz.symlinkcheck.isChecked(): #symlink files
                        try:
                            os.symlink(nfilen, pagepath+filen)
                        except:
                            print "Error creating link:"
                            traceback.print_exc()

                    else: # just copy :-/  diskspace waste
                        try:
                            shutil.copyfile(nfilen,pagepath+filen)
                        except:
                            print "Error copying files:"
                            traceback.print_exc()
            # get thumb captions:
            captions = "<font size=\"-1\">"
            if imgid!= -1:
                for dridx in range(self.wiz.includedcaptionlist.count()):
                    try:
                        captions = captions+str(self.curdb.meta[imgid][str(self.wiz.includedcaptionlist.text(dridx))])+"<br>"
                    except:
                        traceback.print_exc()
                        pass
            else:
                captions = captions+os.path.split(imagelist2[i][0])[-1]+"<br>"
            captions = captions+"</font>"
            imglist.append([filen,filenhs,captions])
        self.showImgs(f,imglist)

    def pageDir(self,dirid,header = ""):
        """create html page for the given dbdir and return html page name"""
        pagename = None
        path = self.curdb.dirs[dirid][0]
        if self.symmode:
            pagename = self.curdb.uniquename( path + str(time.localtime()),".htm" )
            fname = self.destdir+pagename
            pagepath = self.destdir
        else:
            fname = path+"index.htm"
            pagepath = path
            pagename = path
        subhtf = open(fname,"w")
        self.header(subhtf)
        if header:
            self.frame(subhtf,header)
        self.section(subhtf,path)
        f = subhtf
        imagelist = self.curdb.dirs[dirid][3][:]
        subs = []
        if self.wiz.recursecheck.isChecked():
            for i in range(len(self.curdb.dirs[dirid][2])):
                ret = self.pageDir(self.curdb.dirs[dirid][2][i],self.textParentFolder(pagename)) # textParentFolder was ".."
                title = self.curdb.dirs[self.curdb.dirs[dirid][2][i]][0]
                txt = "Images: %d<br>" % len(self.curdb.dirs[self.curdb.dirs[dirid][2][i]][3])
                txt = txt+"Subfolders: %d<br>" % len(self.curdb.dirs[self.curdb.dirs[dirid][2][i]][2])
                if self.symmode:
                    subs.append([ret,title,txt])
                else:
                    subs.append([self.curdb.dirs[self.curdb.dirs[dirid][2][i]][0],title,txt])
            self.showSubs(subhtf,subs)
        self.showImgList(f,imagelist,pagepath)
        self.footer(subhtf)
        subhtf.close()
        # copy style files to dir
        if not self.symmode: self.cpStyle(path)
        return pagename

    def pageSimGroup(self,dirid,header = ""):
        """create html page for the given simgroup and return html page name"""
        path = self.curdb.img[self.curdb.simgroups[dirid][1]][0]
        pagename = self.curdb.uniquename(path+time.asctime()+str(random.randrange(9999939)),".htm")
        fname = self.destdir+pagename
        pagepath = self.destdir
        subhtf = open(fname,"w")
        self.header(subhtf)
        if header:
            self.frame(subhtf,header)
        self.section(subhtf,os.path.split(path)[-1])
        f = subhtf
        imagelist = []
        fils = self.curdb.simgroups[dirid][2]
        for fil in fils:
            #fil = os.path.split(self.curdb.img[fil][0])[-1]
            imagelist.append(self.curdb.img[fil][0])
        subs = []
        self.showImgList(f,imagelist,pagepath)
        self.footer(subhtf)
        subhtf.close()
        # copy style files to dir
        if not self.symmode: self.cpStyle(path)
        return pagename

    def pageVolume(self,dirid,header = ""):
        """create html page for the given path and return html page name"""
        path = self.curdb.volumes[dirid][3]
        pagename = self.curdb.uniquename(path+time.asctime()+str(random.randrange(9999939)),".htm")
        fname = self.destdir+pagename
        pagepath = self.destdir
        subhtf = open(fname,"w")
        self.header(subhtf)
        if header:
            self.frame(subhtf,header)
        self.section(subhtf,path)
        f = subhtf
        imagelist = []
        fils = self.curdb.volumes[dirid][0]
        subs = []
        for i in range(len(fils)):
            if self.curdb.dirs[fils[i]][1] != -1: continue
            ret = self.pageDir(fils[i],self.textParentFolder(pagename))
            title = "%s" % self.curdb.dirs[fils[i]][0]
            txt = "Images: %d<br>" % len(self.curdb.dirs[fils[i]][3])
            txt = txt+"Subfolders: %d<br>" % len(self.curdb.dirs[fils[i]][2])
            subs.append([ret,title,txt])
        self.showSubs(subhtf,subs)
        self.footer(subhtf)
        subhtf.close()
        # copy style files to dir
        if not self.symmode: self.cpStyle(path)
        return pagename

    def pageGroup(self,dirid,header = ""):
        """create html page for the given group and return html page name
        #TODO3: check for bugs here
        """
        path = self.curdb.groups[dirid][0]
        #print time.asctime()+str(random.randrange(9999939))+str(path)
        pagename = self.curdb.hashStr(time.asctime()+str(random.randrange(9999939)))+".htm"
        #print "PAGENAME1" , pagename
        fname = self.destdir+pagename
        pagepath = self.destdir
        subhtf = open(fname,"w")
        self.header(subhtf)
        if header:
            self.frame(subhtf,header)
        self.section(subhtf,path)
        f = subhtf
        imagelist = []
        fils = self.curdb.groups[dirid][3]
        for fil in fils:
            imagelist.append(self.curdb.img[fil][0])
        subs = []
        if self.wiz.recursecheck.isChecked():
            for i in range(len(self.curdb.groups[dirid][4])):
                ret = self.pageGroup(self.curdb.groups[dirid][4][i],self.textParentFolder(pagename))
                tit = "%s" % os.path.split(self.curdb.groups[self.curdb.groups[dirid][4][i]][0])[-1]
                txt = "<font size=-1>Images: %d<br>" % len(self.curdb.groups[self.curdb.groups[dirid][4][i]][3])
                txt = txt+"Subgroups: %d<br></font>" % len(self.curdb.groups[self.curdb.groups[dirid][4][i]][4])
                subs.append([ret,tit,txt])
            self.showSubs(subhtf,subs)
        self.showImgList(f,imagelist,pagepath)
        self.footer(subhtf)
        subhtf.close()
        # copy style files to dir
        if not self.symmode: self.cpStyle(path)
        #print "PAGENAME" , pagename
        return pagename

    def pagePath(self,path,header = ""):
        """create html page for the given path and return html page name when on symlink mode"""
        if path[-1] != os.sep: path = path+os.sep
        pagename = None
        if self.symmode:
            pagename = self.curdb.hashStr(time.asctime()+str(random.randrange(9999939)))[:8]+".htm"
            fname = self.destdir+pagename
            pagepath = self.destdir
        else:
            fname = path+"index.htm"
            pagepath = path
            pagename = path
        subhtf = open(fname,"w")
        self.header(subhtf)
        if header:
            self.frame(subhtf,header)
        self.section(subhtf,path)
        f = subhtf
        imagelist = []
        subdirs = []
        fils = os.listdir(path)
        for fil in fils:
            if fil[0] == ".": continue
            if os.path.isdir(path+fil):
                subdirs.append(fil)
            else:
                if self.curdb.extIsImg(fil) :
                    imagelist.append(path+fil)
        subs = []
        if self.wiz.recursecheck.isChecked():
            for i in range(len(subdirs)):
                ret = self.pagePath(path+subdirs[i],self.textParentFolder(".."))
                if self.symmode:
                    subs.append([ret,subdirs[i],""])
                else:
                    subs.append([subdirs[i],subdirs[i],""])
            self.showSubs(subhtf,subs)
        self.showImgList(f,imagelist,pagepath)
        self.footer(subhtf)
        subhtf.close()
        # copy style files to dir
        if not self.symmode: self.cpStyle(path)
        return pagename
    
    def textParentFolder(self,pagename):
        """returns the text to be included when you want a link to the parent folder which is pointed by pagename """
        return "<img border = 0 src=\"uparrow.png\"><a href=\""+pagename+"\">Parent folder</a>"
    
    def showSubs(self,f,subs):
        """write subdirs inside this page """
        # [href,caption,info]
        txt = "<h1>Subfolders:</h1>"
        if not subs:return
        for i in subs:
            if i[2]:
                txt = txt+"<img border=0 src=\"right.png\"><a href=\"" + i[0] + "\">"+i[1]+"</a><br>"+i[2]+"<br>"
            else:
                txt = txt+"<img border=0 src=\"right.png\"><a href=\"" + i[0] + "\">"+i[1]+"</a><br>"
        self.frame(f,txt)
        
    def showImgs(self,f,imglist):
        """ write to f all the images in imglist where imglist is:"""
        # [href,imgsrc,caption]
        thperrow = 4                      # thumnails per row
        f.write("""<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">""")
        for i in range(len(imglist)):
            if i%thperrow==0:
                f.write("</tr>")
                f.write("<tr>")
            f.write("<td align = center>")
            if not self.leafpage:
                tntarget = imglist[i][0][:rfind(imglist[i][0],'.')]+".htm"
                singleimagefile = open(self.destdir+tntarget,"w")
                self.header(singleimagefile,imglist[i][0])
                header = self.textParentFolder(self.serverroot+f.name[f.name.rfind("/")+1:])
                #print "Header ist ",header
                self.frame(singleimagefile,header)
                self.frame(singleimagefile,"<center><a href=\""+imglist[i][0]+"\">"+"<img border = 0 width=800 src=\""+imglist[i][0]+"\"></a><br><font size=\"-1\">"+imglist[i][2]+"</font></center>")
                if (i-1) < 0:
                    prevImgLink = ""
                else:
                    prevImgLink = "<a href=\"" + imglist[i-1][0][:rfind(imglist[i-1][0],'.')]+".htm\"><img border=0 src=\"left.png\" alt=\"Previous Image\"></a>"
                if (i+1) >= len(imglist):
                    nextImgLink = ""
                else:
                    nextImgLink = "<a href=\"" + imglist[i+1][0][:rfind(imglist[i+1][0],'.')]+".htm\"><img border=0 src=\"right.png\" alt=\"Next Image\"></a>"
                self.footer(singleimagefile,prevImgLink,nextImgLink)
                singleimagefile.close()
            else:
                tntarget = imglist[i][0]
            self.frame(f,"<center><a href=\""+tntarget+"\">"+"<img border = 0 src=\""+imglist[i][1]+"\"></a><br><font size=\"-1\">"+
                       imglist[i][2]+"</font></center>")
            f.write("</td>")
        f.write("""</table>""")
        
    def header(self,f,title = "Photo Album"):
        f.write("""
<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html>
<!--	Generated by: imgSeek
	http://imgseek.sourceforge.net/
-->
<head>
    <title>"""+title+"""</title>
    <link rel=\"STYLESHEET\" type=\"text/css\" href=\"style.css\">
</head>
<body background=\"bg.png\" dir=\"ltr\">
""")

    def footer(self,f,prevImgLink="",nextImgLink=""):
        f.write("""
<hr>""" + prevImgLink + " " + nextImgLink + """
<hr>
Generated by <a href=\"http://imgseek.sourceforge.net\">imgSeek</a> - """ +time.asctime(time.localtime()) + """
</body>
</html>
""")

    def section(self,f,title = ""):
        self.frame(f,"""<center><h2>"""+title+"""</h2></center>""")

    def frame(self,f,txt = ""):
        f.write(self.getframetext(txt))
        
    def getframetext(self,txt = ""):
        return """
<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
  <tr>
    <td width=\"15\" height=\"15\" background=\"coinsupg.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
    <td height=\"15\" background=\"sup.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
    <td width=\"15\" height=\"15\" background=\"coinsupd.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
  </tr>
  <tr>
   <td width=\"15\" background=\"g.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
   <td background=\"fond.png\" align=\"left\" >"""+txt+"""</td>
   <td width=\"15\" background=\"d.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
  </tr>
  <tr>
    <td width=\"15\" height=\"15\" background=\"coininfg.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
    <td height=\"15\" background=\"inf.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
    <td width=\"15\" height=\"15\" background=\"coininfd.png\"><img src=\"space15.png\" width=\"15\" height=\"15\" alt=\"none\"></td>
  </tr>
</table>
"""
    def framebig(self,f,title = "",txt=""):
        self.frame(f,"""<h1>"""+title+"</h1><br>"+txt)
