 if ("undefined" == typeof(ImapAclExt.Utils)) {
  ImapAclExt.Utils = {
	_resCache : new Array(),	
	TIMEOUT : 3,
	Cc : Components.classes,
	Ci : Components.interfaces,
	transport : null,
	secinfo : null,
	timeoutTimer : null,

	//check return codes!
	setAcl : function (imapFolder, user, acl) {
		var result = this.sendToServer(imapFolder.server, "SETACL \"" +
			imapFolder.onlineName + "\" \"" + user + "\" \"" + acl + "\"", true);

		if (result == "success") {
			imapFolder.addFolderRights(user, acl);
			imapFolder.refreshFolderRights();
		}

		return result;
	},

	delAcl : function (imapFolder, user) {
		var result = this.sendToServer(imapFolder.server, "DELETEACL \"" +
			imapFolder.onlineName + "\" \"" + user + "\"", true);

		if (result == "success") {
			imapFolder.addFolderRights(user, "");
			imapFolder.refreshFolderRights();
		}

		return result;
	},
	
	check : function (imapFolder) {		
		var result = this.sendToServer(imapFolder.server, "GETACL \"" +
			imapFolder.onlineName + "\"", false);

		var header = result[0].toLowerCase();

		if ((header.indexOf("acl") >= 0 && header.indexOf("courier-imap") >= 0) || 
			this.Cc['@mozilla.org/preferences-service;1'].getService(this.Ci.nsIPrefBranch).getBoolPref("extensions.ImapAclExt.compatMode")) {
			
			var aclRes = null;
			
			if (result[2].toLowerCase().indexOf("acl") >=0) {
				aclRes = result[2];
			} else if (result[3].toLowerCase().indexOf("acl") >=0) {
				aclRes = result[3];
			}
			
			if (aclRes.indexOf("\n") >= 0)
				aclRes = aclRes.split("\n")[0];
			
			var acls = aclRes.split(" ");
			var found = false;
			var mode = 0;
			var rights = new Array();
			
			for (i = 0; i < acls.length; ++i) {
				if (acls[i].indexOf(imapFolder.onlineName) >= 0) {
					found = true;
					mode = 1;
					continue;
				}				
				if (mode == 1) {
					user = acls[i].replace(/"/g,"");
					if (user == "owner")
						user = imapFolder.server.realUsername;
					++mode;
					continue;
				}
				if (mode ==2) {
					rights[user] = acls[i].replace(/"/g,"");
					imapFolder.addFolderRights(user, rights[user]);
					mode = 1
					continue;
				}
					
			}
			
			//(imapFolder.server.realUsername != user) 
			//imapFolder.addFolderRights(user, acl);
			imapFolder.refreshFolderRights();
		}

		return result;
	},

	rand4ints : function() {
		return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
	},
	
	guid : function() {
		return (this.rand4ints()+this.rand4ints()+"-"+this.rand4ints()+"-"+this.rand4ints()+"-"+
			this.rand4ints()+"-"+this.rand4ints()+this.rand4ints()+this.rand4ints());
	},

	onResult : function(res, uid, isACLCommand) {
		if (res != null && res.length > 2) {
			var response = null;
			if (isACLCommand) {
				if (res[2].indexOf("a003") == 0) {
					response = res[2].toLowerCase();
				} else if (res[3].indexOf("a003") == 0) {
					response = res[3].toLowerCase();
				}
							
				if (response != null && response.indexOf("ok") != -1 && 
					(response.indexOf("setacl") != -1 ||
						response.indexOf("deleteacl") != -1 ||
						response.indexOf("completed") != -1 ||
						response.indexOf("updated") != -1)) {
					
					this._resCache[uid] = "success";
					return;
				} else if (response != null && response.indexOf("no") != -1) {
					this._resCache[uid] = "noAclRight";
					return;
				}
			} else {
				this._resCache[uid] = res;
				return;
			}
		}
		
		this._resCache[uid] = "Unknown Imap error!";
	},
	/**
	 * Sleep for the given amount of milliseconds
	 **/
	sleep : function ( milliseconds ) {
	  var self = {};
	  var hwindow = Components.classes["@mozilla.org/appshell/appShellService;1"]
              .getService(Components.interfaces.nsIAppShellService)
              .hiddenDOMWindow;
	  // We basically just call this once after the specified number of milliseconds
	  function wait() {
		self.timeup = true;
	  }

	  // Calls repeatedly every X milliseconds until clearInterval is called
	  var interval = hwindow.setInterval(wait, milliseconds);

	  var thread = Components.classes["@mozilla.org/thread-manager;1"]
				.getService()
				.currentThread;
	  // This blocks execution until our while loop condition is invalidated.  Note
	  // that you must use a simple boolean expression for the loop, a function call
	  // will not work.
	  while(!self.timeup)
		thread.processNextEvent(true);
	  hwindow.clearInterval(interval);

	  return true;
	},
	
	sendToServer : function (server, command, isACLCommand, retrieveFlag)
	{
		var uid = this.guid();
		var index = 0;
		var initialized = false;
		var protocolData = new Array();
		var inst = this;
		this._resCache[uid] = "waiting";
		
		try
		{
			function timeoutFunc()
			{
					if (!initialized) {
						inst._resCache[uid] = "Connection Timeout!";
					}
			}		
			
			var secType = null;
			var secLength = 0;
			var starttlsMode = false;
			if (server.socketType == 3) {
				secType = ['ssl'];
				secLength = 1;
			} else if (server.socketType == 2) {
				secType = ['starttls'];
				secLength = 1;
				starttlsMode = true;
			}

			if (this.timeoutTimer == null)
				this.timeoutTimer = this.Cc["@mozilla.org/timer;1"].createInstance(this.Ci.nsITimer);
			
			this.timeoutTimer.initWithCallback({ notify: function(timer) { timeoutFunc(); } }, 3000, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
			
			var transportService = this.Cc["@mozilla.org/network/socket-transport-service;1"]
							   .getService(this.Ci.nsISocketTransportService);
			
			this.transport = transportService.createTransport(secType, secLength,
										server.realHostName, server.port, null);

			this.transport.setTimeout(this.Ci.nsISocketTransport.TIMEOUT_CONNECT, this.TIMEOUT);
			this.transport.setTimeout(this.Ci.nsISocketTransport.TIMEOUT_READ_WRITE, this.TIMEOUT);			
						
			var outstream = this.transport.openOutputStream(0,0,0);
			var stream = this.transport.openInputStream(0,0,0);
			var instream = this.Cc["@mozilla.org/scriptableinputstream;1"]
					   .createInstance(this.Ci.nsIScriptableInputStream);

			instream.init(stream);

			if (starttlsMode) {
				protocolData.push("a001 STARTTLS" + "\r\n");
			}
			
			protocolData.push("a002 LOGIN " + server.realUsername + " " + server.password + "\r\n");
			protocolData.push("a003 " + command + "\r\n");
			protocolData.push("a004 LOGOUT" + "\r\n");

			var dataListener =
			{
				data : new Array(),
				onStartRequest: function(request, context)
				{
					initialized = true;
				},
				onStopRequest: function(request, context, status)
				{
					instream.close();
					outstream.close();
					
					inst.onResult(this.data,uid,isACLCommand,retrieveFlag);
				},
				onDataAvailable: function(request, context, inputStream, offset, count)
				{
					let inputData = instream.read(count);
					
					if (starttlsMode && inputData.indexOf("a001") == 0 && 
						inputData.indexOf("OK") != -1 && inputData.indexOf("TLS") != -1) {
						
						inst.secInfo.StartTLS();
					} 
										
					this.data.push(inputData);
					
					if (index < protocolData.length) {
						let outputData = protocolData[index++];
						outstream.write(outputData, outputData.length);
					}
				}
			};

			var pump = this.Cc["@mozilla.org/network/input-stream-pump;1"]
					   .createInstance(this.Ci.nsIInputStreamPump);

			pump.init(stream, -1, -1, 0, 0, false);
			
			if (starttlsMode) {
				
				var countdown = 0;
				while(!this.transport.isAlive() && countdown++ < this.TIMEOUT) {
					//secinfo only avail. when socket is connected, 
					//this can take up to a few sec!
					this.sleep(500);
				}
				
				this.secInfo = this.transport.securityInfo;
				this.secInfo.QueryInterface(this.Ci.nsISSLSocketControl);
			}
			
			pump.asyncRead(dataListener, null);
			
			while(this._resCache[uid] == "waiting") {
				this.sleep(500);
			}

		}
		catch (ex) {
			this._resCache[uid] = ex;
		}
		
		return this._resCache[uid];
	}
  };
};
